/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.stash.idx.IndexedChangeset;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.idx.InternalChangesetAttribute;
import com.atlassian.stash.internal.idx.InternalRepositoryMembership;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Immutable;
import org.springframework.util.ObjectUtils;

@Entity
@Table(name="changeset")
@Immutable
public class InternalIndexedChangeset
implements IndexedChangeset,
Initializable {
    @Id
    @Column(name="id")
    @RequiredString(size=40)
    private final String id;
    @Column(name="author_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date authorTimestamp;
    @OneToMany(mappedBy="changeset", cascade={CascadeType.REMOVE})
    private Set<InternalRepositoryMembership> repositoryMemberships;
    @OneToMany(mappedBy="changeset", cascade={CascadeType.REMOVE})
    private Set<InternalChangesetAttribute> attributes;

    protected InternalIndexedChangeset() {
        this.id = null;
        this.authorTimestamp = null;
    }

    public InternalIndexedChangeset(String id, Date authorTimestamp) {
        this.id = id;
        this.authorTimestamp = authorTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalIndexedChangeset) {
            InternalIndexedChangeset that = (InternalIndexedChangeset)o;
            return ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)that.getId());
        }
        return false;
    }

    @Nonnull
    public Date getAuthorTimestamp() {
        return this.authorTimestamp;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public Set<InternalRepositoryMembership> getRepositoryMemberships() {
        return this.repositoryMemberships;
    }

    @Nonnull
    public Set<Repository> getRepositories() {
        Set<InternalRepositoryMembership> repositoryMemberships = this.getRepositoryMemberships();
        if (repositoryMemberships == null) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf((Collection)Collections2.transform(repositoryMemberships, (Function)new Function<InternalRepositoryMembership, Repository>(){

            public InternalRepository apply(InternalRepositoryMembership membership) {
                return membership.getRepository();
            }
        }));
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.getId());
    }

    @Override
    public void initialize() {
        this.repositoryMemberships = HibernateUtils.initializeSet(this.getRepositoryMemberships());
    }

    public String toString() {
        return this.id;
    }
}

