/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.trusted;

import com.atlassian.stash.internal.auth.trusted.InternalTrustedApplicationRestriction;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.CustomPreconditions;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.apache.commons.codec.binary.Base64;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.springframework.util.ObjectUtils;

@Entity
@Cacheable
@Table(name="trusted_app")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalTrustedApplication {
    private static final String ID_GEN = "trustedAppIdGenerator";
    static final String TABLE = "trusted_app";
    @TableGenerator(name="trustedAppIdGenerator", table="id_sequence", pkColumnValue="trusted_app", allocationSize=10)
    @Id
    @GeneratedValue(generator="trustedAppIdGenerator", strategy=GenerationType.TABLE)
    private final Integer id;
    @Column(name="application_id", nullable=false, unique=true)
    @RequiredString(size=255)
    private final String applicationId;
    @Column(name="public_key_base64", nullable=false)
    @RequiredString(size=4000)
    private final String publicKeyBase64;
    @Transient
    private volatile transient byte[] publicKey;
    @OneToMany(mappedBy="application", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private final Set<InternalTrustedApplicationRestriction> restrictions;
    @Column(name="certificate_timeout", nullable=false)
    private final long certificateTimeout;

    protected InternalTrustedApplication() {
        this.id = null;
        this.applicationId = null;
        this.publicKeyBase64 = null;
        this.certificateTimeout = 1000L;
        this.restrictions = Collections.emptySet();
    }

    private InternalTrustedApplication(Builder builder) {
        this.id = builder.id;
        this.applicationId = builder.applicationId;
        this.publicKey = builder.publicKey;
        this.publicKeyBase64 = new String(Base64.encodeBase64((byte[])this.publicKey));
        this.certificateTimeout = builder.certificateTimeout;
        ImmutableSet.Builder restrictionBuilder = ImmutableSet.builder();
        for (InternalTrustedApplicationRestriction restriction : builder.restrictions) {
            restrictionBuilder.add((Object)new InternalTrustedApplicationRestriction(restriction.getId(), this, restriction.getType(), restriction.getValue()));
        }
        this.restrictions = restrictionBuilder.build();
        CustomPreconditions.checkRequiredString((String)this.applicationId, (int)255);
        CustomPreconditions.checkRequiredString((String)this.publicKeyBase64, (int)4000);
    }

    public static InternalTrustedApplication initialize(InternalTrustedApplication app) {
        if (app != null) {
            app.initialize();
        }
        return app;
    }

    protected void initialize() {
        Hibernate.initialize(this.getRestrictions());
        for (InternalTrustedApplicationRestriction restriction : this.getRestrictions()) {
            Hibernate.initialize((Object)restriction);
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public byte[] getPublicKey() {
        if (this.publicKey == null) {
            this.publicKey = Base64.decodeBase64((byte[])this.publicKeyBase64.getBytes());
        }
        return this.publicKey;
    }

    public Set<InternalTrustedApplicationRestriction> getRestrictions() {
        return this.restrictions;
    }

    public Iterable<String> getIPPatterns() {
        return Chainable.chain(this.getRestrictions()).filter(this.byType(InternalTrustedApplicationRestriction.Type.IP)).transform(this.restrictionToString());
    }

    public Iterable<String> getUrlPatterns() {
        return Chainable.chain(this.getRestrictions()).filter(this.byType(InternalTrustedApplicationRestriction.Type.URL)).transform(this.restrictionToString());
    }

    public long getCertificateTimeout() {
        return this.certificateTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalTrustedApplication)) {
            return false;
        }
        InternalTrustedApplication that = (InternalTrustedApplication)o;
        return ObjectUtils.nullSafeEquals((Object)this.getApplicationId(), (Object)that.getApplicationId());
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.getApplicationId());
    }

    public Builder copy() {
        return new Builder(this);
    }

    private Predicate<? super InternalTrustedApplicationRestriction> byType(final InternalTrustedApplicationRestriction.Type type) {
        return new Predicate<InternalTrustedApplicationRestriction>(){

            public boolean apply(InternalTrustedApplicationRestriction input) {
                return input.getType() == type;
            }
        };
    }

    private Function<InternalTrustedApplicationRestriction, String> restrictionToString() {
        return new Function<InternalTrustedApplicationRestriction, String>(){

            public String apply(InternalTrustedApplicationRestriction input) {
                return input.getValue();
            }
        };
    }

    public static class Builder {
        private final Set<InternalTrustedApplicationRestriction> restrictions;
        private String applicationId;
        private long certificateTimeout;
        private Integer id;
        private byte[] publicKey;

        public Builder() {
            this.restrictions = Sets.newHashSet();
        }

        public Builder(InternalTrustedApplication trustedApp) {
            this.applicationId = trustedApp.getApplicationId();
            this.certificateTimeout = trustedApp.getCertificateTimeout();
            this.id = trustedApp.getId();
            this.publicKey = trustedApp.getPublicKey();
            this.restrictions = Sets.newHashSet(trustedApp.getRestrictions());
        }

        public Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public Builder certificateTimeout(long certificateTimeout) {
            this.certificateTimeout = certificateTimeout;
            return this;
        }

        public Builder ipPatterns(Iterable<String> ipPatterns) {
            this.setRestrictions(InternalTrustedApplicationRestriction.Type.IP, ipPatterns);
            return this;
        }

        public Builder urlPatterns(Iterable<String> urlPatterns) {
            this.setRestrictions(InternalTrustedApplicationRestriction.Type.URL, urlPatterns);
            return this;
        }

        public InternalTrustedApplication build() {
            return new InternalTrustedApplication(this);
        }

        private void setRestrictions(InternalTrustedApplicationRestriction.Type type, Iterable<String> values) {
            HashSet newValues = Sets.newHashSet(values);
            Iterator<InternalTrustedApplicationRestriction> it = this.restrictions.iterator();
            while (it.hasNext()) {
                InternalTrustedApplicationRestriction restriction = it.next();
                if (restriction.getType() != type || newValues.remove(restriction.getValue())) continue;
                it.remove();
            }
            for (String value : newValues) {
                this.restrictions.add(new InternalTrustedApplicationRestriction(null, type, value));
            }
        }
    }
}

