/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.constraints.RepositoryUniqueness;
import com.atlassian.stash.internal.idx.InternalChangesetIndexerState;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.ScmType;
import com.atlassian.stash.validation.ConstraintNature;
import java.text.Normalizer;
import java.util.Locale;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.springframework.util.ObjectUtils;

@Entity
@Cacheable
@Table(name="repository", uniqueConstraints={@UniqueConstraint(columnNames={"slug", "project_id"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@RepositoryUniqueness(payload={ConstraintNature.Conflict.class})
public class InternalRepository
implements Repository {
    private static final String ID_GEN = "repoIdGenerator";
    static final String TABLE = "repository";
    @TableGenerator(name="repoIdGenerator", table="id_sequence", pkColumnValue="repository", allocationSize=10)
    @Id
    @GeneratedValue(generator="repoIdGenerator", strategy=GenerationType.TABLE)
    private final Integer id;
    @Column(name="slug")
    private final String slug;
    @Column(name="name")
    private final String name;
    @Column(name="state", nullable=false)
    @Type(type="com.atlassian.stash.internal.hibernate.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.repository.Repository$State")})
    private final Repository.State state;
    @Column(name="status")
    private final String statusMessage;
    @Column(name="scmtype")
    @Type(type="com.atlassian.stash.internal.hibernate.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.repository.ScmType")})
    private final ScmType scmType;
    @OneToOne
    @JoinColumn(name="origin_id")
    private final InternalRepository origin;
    @ManyToOne
    @JoinColumn(name="project_id")
    private final InternalProject project;
    @OneToMany(mappedBy="repository", cascade={CascadeType.REMOVE})
    private Set<InternalChangesetIndexerState> indexerStates;

    protected InternalRepository() {
        this.id = null;
        this.slug = null;
        this.name = null;
        this.state = null;
        this.statusMessage = null;
        this.scmType = null;
        this.origin = null;
        this.project = null;
    }

    protected InternalRepository(InternalProject project, String name, ScmType type, InternalRepository origin) {
        this(null, project, InternalRepository.slugify(name), name, type, origin, null, null);
    }

    protected InternalRepository(Integer id, InternalProject project, String slug, String name, ScmType type, InternalRepository origin, Repository.State state, String statusMessage) {
        this.id = id;
        this.project = project;
        this.slug = slug;
        this.name = name;
        this.scmType = type;
        this.origin = origin;
        this.state = state == null ? Repository.State.INITIALISING : state;
        this.statusMessage = statusMessage;
    }

    public Integer getId() {
        return this.id;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getName() {
        return this.name;
    }

    public ScmType getScmType() {
        return this.scmType;
    }

    public InternalRepository getOrigin() {
        return this.origin;
    }

    public InternalProject getProject() {
        return this.project;
    }

    public Repository.State getState() {
        return this.state;
    }

    public String getStatusMessage() {
        return this.statusMessage == null ? this.getState().getStatusMessage() : this.statusMessage;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalRepository)) {
            return false;
        }
        InternalRepository that = (InternalRepository)o;
        return ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)that.getId());
    }

    public static String slugify(String name) {
        String normalized = Normalizer.normalize(name, Normalizer.Form.NFKD);
        normalized = normalized.replaceAll("[^\\p{InBasicLatin}]+", "");
        return normalized.replaceAll("[^a-zA-Z\\-_0-9\\.]+", "-").toLowerCase(Locale.US);
    }

    public Builder copy() {
        return new Builder(this);
    }

    public static class Builder {
        private Integer id;
        private String slug;
        private String name;
        private Repository.State state;
        private String statusMessage;
        private ScmType scmType;
        private InternalRepository origin;
        private InternalProject project;

        public Builder() {
        }

        public Builder(InternalRepository repo) {
            this.id = repo.getId();
            this.slug = repo.getSlug();
            this.name = repo.getName();
            this.state = repo.getState();
            this.statusMessage = repo.getStatusMessage();
            this.scmType = repo.getScmType();
            this.origin = repo.getOrigin();
            this.project = repo.getProject();
        }

        public Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.slug = InternalRepository.slugify(name);
            return this;
        }

        public Builder state(Repository.State state) {
            this.state = state;
            return this;
        }

        public Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Builder scmType(ScmType scmType) {
            this.scmType = scmType;
            return this;
        }

        public Builder project(InternalProject project) {
            this.project = project;
            return this;
        }

        public Builder origin(InternalRepository origin) {
            this.origin = origin;
            return this;
        }

        public InternalRepository build() {
            return new InternalRepository(this.id, this.project, this.slug != null ? this.slug : InternalRepository.slugify(this.name), this.name, this.scmType, this.origin, this.state, this.statusMessage);
        }
    }
}

