/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.stash.idx.IndexedChangeset;
import com.atlassian.stash.internal.idx.InternalChangesetAttribute;
import com.atlassian.stash.internal.idx.InternalRepositoryMembership;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.ObjectUtils;

@Entity
@Table(name="changeset")
public class InternalIndexedChangeset
implements IndexedChangeset {
    @Id
    @Column(name="id")
    @RequiredString(size=40)
    private final String id;
    @Column(name="author_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date authorTimestamp;
    @OneToMany(mappedBy="changeset", cascade={CascadeType.REMOVE})
    private Set<InternalRepositoryMembership> repositoryMemberships;
    @OneToMany(mappedBy="changeset", cascade={CascadeType.REMOVE})
    private Set<InternalChangesetAttribute> attributes;

    protected InternalIndexedChangeset() {
        this.id = null;
        this.authorTimestamp = null;
    }

    public InternalIndexedChangeset(String id, Date authorTimestamp) {
        this.id = id;
        this.authorTimestamp = authorTimestamp;
    }

    public String getId() {
        return this.id;
    }

    public Date getAuthorTimestamp() {
        return this.authorTimestamp;
    }

    public Set<InternalRepositoryMembership> getRepositoryMemberships() {
        return this.repositoryMemberships;
    }

    public Set<Repository> getRepositories() {
        if (this.repositoryMemberships != null) {
            return Sets.newHashSet((Iterable)Iterables.transform(this.repositoryMemberships, (Function)new Function<InternalRepositoryMembership, Repository>(){

                public InternalRepository apply(InternalRepositoryMembership membership) {
                    return membership.getRepository();
                }
            }));
        }
        return Collections.emptySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalIndexedChangeset) {
            InternalIndexedChangeset that = (InternalIndexedChangeset)o;
            return ObjectUtils.equals((Object)this.id, (Object)that.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return this.id;
    }
}

