/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.constraints;

import com.atlassian.stash.internal.constraints.ProjectNameUnique;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.util.Operation;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectNameValidator
implements ConstraintValidator<ProjectNameUnique, InternalProject> {
    private ProjectService projectService;
    private SecurityService securityService;

    @Autowired
    public void setProjectService(ProjectService projectService) {
        this.projectService = projectService;
    }

    @Autowired
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void initialize(ProjectNameUnique constraintAnnotation) {
    }

    public boolean isValid(final InternalProject value, final ConstraintValidatorContext context) {
        if (value == null || this.projectService == null || this.securityService == null) {
            return true;
        }
        boolean valid = true;
        if (value.getName() == null) {
            return false;
        }
        return (Boolean)this.securityService.doWithPermission("validate project name uniqueness", Permission.PROJECT_READ, (Operation)new Operation<Boolean, RuntimeException>(){

            public Boolean perform() throws RuntimeException {
                Project projectByName = ProjectNameValidator.this.projectService.findByName(value.getName());
                if (projectByName != null && !projectByName.getId().equals(value.getId())) {
                    context.disableDefaultConstraintViolation();
                    ConstraintValidatorContext.ConstraintViolationBuilder builder = context.buildConstraintViolationWithTemplate("{com.atlassian.stash.validation.project.name.unique.message}");
                    builder.addNode("name");
                    builder.addConstraintViolation();
                    return false;
                }
                return true;
            }
        });
    }
}

