/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.UnsupportedChangeException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class RescopeRequestIdSequenceChange
extends AbstractCustomChange
implements CustomTaskChange,
CustomTaskRollback {
    private Long nextVal;

    public void execute(Database database) throws CustomChangeException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
        try {
            Long highestId = this.getHighestRescopeRequestId(template);
            if (highestId != null) {
                this.nextVal = highestId + 1000L;
                template.update("insert into id_sequence (sequence_name, next_val) values('sta_pr_rescope_request', ?)", new Object[]{this.nextVal});
            }
        }
        catch (DataAccessException e) {
            throw new CustomChangeException("Could not initialize id_sequence for sequence 'sta_pr_rescope_request'", (Throwable)e);
        }
    }

    public String getConfirmationMessage() {
        return this.nextVal == null ? "No need to initialize id_sequence for 'sta_pr_rescope_request'. No rescope requests were found." : "Initialized id_sequence for sequence 'sta_pr_rescope_request' to " + this.nextVal;
    }

    public void rollback(Database database) throws CustomChangeException, UnsupportedChangeException, RollbackImpossibleException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
        try {
            template.update("delete from id_sequence where sequence_name='sta_pr_rescope_request'");
        }
        catch (DataAccessException e) {
            throw new CustomChangeException("Initialization of id_sequence for 'sta_pr_rescope_request' could not be rolled back", (Throwable)e);
        }
    }

    private Long getHighestRescopeRequestId(JdbcTemplate template) {
        return (Long)template.queryForObject("select max(id) from sta_pr_rescope_request", Long.class);
    }
}

