/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.atlassian.stash.internal.hibernate.DataSourceConfiguration;
import com.atlassian.stash.internal.hibernate.LeasedConnectionTracker;
import com.atlassian.stash.internal.util.StackException;
import com.atlassian.stash.util.Drainable;
import com.atlassian.stash.util.ForcedDrainable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.jolbox.bonecp.BoneCPDataSource;
import com.jolbox.bonecp.ConnectionHandle;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedBoneCPDataSource
extends BoneCPDataSource
implements Closeable,
DataSource,
Drainable,
ForcedDrainable {
    private static final long DEFAULT_DRAIN_POLL_INTERVAL = TimeUnit.SECONDS.toMillis(2L);
    private static final Logger log = LoggerFactory.getLogger(ExtendedBoneCPDataSource.class);
    private LeasedConnectionTracker leasedConnectionTracker;
    private long drainPollInterval = DEFAULT_DRAIN_POLL_INTERVAL;

    public ExtendedBoneCPDataSource(DataSourceConfiguration configuration) {
        this.setDriverClass(configuration.getDriverClassName());
        this.setDriverProperties(configuration.getProperties());
        this.setJdbcUrl(configuration.getUrl());
        this.setPassword(configuration.getPassword());
        this.setUsername(configuration.getUser());
    }

    public boolean drain(long timeout, @Nonnull TimeUnit unit) {
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout must be non-negative");
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit");
        return this.drainInterruptibly(timeout, unit) == DrainResult.DRAINED || this.isDrained();
    }

    public boolean forceDrain(long timeout, @Nonnull TimeUnit unit) {
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout must be non-negative");
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit");
        if (this.isDrained()) {
            return true;
        }
        log.info("Force draining the connection pool");
        log.debug("{} connections still leased. Owning threads will be interrupted with a {} {} delay", new Object[]{this.getTotalLeased(), timeout, unit});
        this.interruptThreadsWithConnections();
        switch (this.drainInterruptibly(timeout, unit)) {
            case INTERRUPTED: {
                return this.isDrained();
            }
            case DRAINED: {
                return true;
            }
        }
        log.debug("{} connections still leased; all leased connections will now be rolled back and closed", (Object)this.getTotalLeased());
        this.forceRollbackAndCloseConnections();
        int totalLeased = this.getTotalLeased();
        log.info("{} connections still leased; forced draining has {}", (Object)totalLeased, (Object)(totalLeased == 0 ? "succeeded" : "failed"));
        return totalLeased == 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        return java.util.logging.Logger.getLogger("global");
    }

    public void setConnectionTimeoutInSeconds(int connectionTimeout) {
        this.setConnectionTimeoutInMs(TimeUnit.SECONDS.toMillis(connectionTimeout));
    }

    @VisibleForTesting
    void setDrainPollInterval(long drainPollInterval) {
        this.drainPollInterval = drainPollInterval;
    }

    public void setLeasedConnectionTracker(LeasedConnectionTracker leasedConnectionTracker) {
        this.leasedConnectionTracker = leasedConnectionTracker;
    }

    private void forceRollbackAndCloseConnections() {
        for (ConnectionHandle leased : this.leasedConnectionTracker.getLeased()) {
            Thread lessee = leased.getThreadUsingConnection();
            String threadName = this.threadName(lessee);
            try {
                log.info("Rolling back database connection in use by thread \"{}\"", (Object)threadName, lessee != null && log.isDebugEnabled() ? new StackException(lessee) : null);
                leased.rollback();
            }
            catch (Exception e) {
                log.debug("Failed to roll back database connection in use by thread \"{}\"", (Object)threadName, (Object)e);
            }
            try {
                if (leased.isClosed()) continue;
                log.info("Closing database connection in use by thread \"{}\"", (Object)threadName);
                leased.close();
            }
            catch (Exception e) {
                log.debug("Failed to close database connection in use by thread \"{}\"", (Object)threadName, (Object)e);
            }
        }
    }

    private void interruptThreadsWithConnections() {
        for (ConnectionHandle leased : this.leasedConnectionTracker.getLeased()) {
            Thread lessee = leased.getThreadUsingConnection();
            if (lessee == null) continue;
            log.debug("Thread \"{}\" is holding onto a database connection. It is delaying the pool from draining", (Object)this.threadName(lessee), (Object)new StackException(lessee));
            lessee.interrupt();
        }
    }

    private boolean isDrained() {
        return this.getTotalLeased() == 0;
    }

    private DrainResult drainInterruptibly(long timeout, @Nonnull TimeUnit unit) {
        long start = System.currentTimeMillis();
        long end = start + unit.toMillis(timeout);
        log.debug("Draining the connection pool");
        int leased = this.getTotalLeased();
        while (leased > 0) {
            long tilEnd = end - System.currentTimeMillis();
            long interval = Math.min(this.drainPollInterval, tilEnd);
            if (tilEnd <= 0L) {
                log.debug("The connection pool did not drain in {} {}; {} connections are still leased", new Object[]{timeout, unit, leased});
                return DrainResult.TIMED_OUT;
            }
            log.debug("{} connections still leased; waiting {} milliseconds", (Object)leased, (Object)interval);
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debug("Interrupted while waiting for the connection pool to drain");
                return DrainResult.INTERRUPTED;
            }
            leased = this.getTotalLeased();
        }
        log.debug("The connection pool has drained in {} milliseconds", (Object)(System.currentTimeMillis() - start));
        return DrainResult.DRAINED;
    }

    private String threadName(Thread thread) {
        return thread == null ? "<unknown>" : thread.getName();
    }

    private static enum DrainResult {
        DRAINED,
        TIMED_OUT,
        INTERRUPTED;

    }
}

