/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.atlassian.stash.internal.hibernate.SwappableDataSource;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.springframework.core.InfrastructureProxy;

public class DelegatingSwappableDataSource
implements Closeable,
SwappableDataSource {
    private volatile DataSource delegate;

    public DelegatingSwappableDataSource(DataSource delegate) {
        this.delegate = delegate;
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.delegate instanceof Closeable) {
            Closeables.closeQuietly((Closeable)((Closeable)((Object)this.delegate)));
        }
    }

    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.delegate.getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    public Logger getParentLogger() {
        return Logger.getLogger("global");
    }

    public DataSource getWrappedObject() {
        DataSource delegate = this.delegate;
        return delegate instanceof InfrastructureProxy ? (DataSource)((InfrastructureProxy)delegate).getWrappedObject() : delegate;
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Nonnull
    public DataSource swap(@Nonnull DataSource target) {
        DataSource old = this.delegate;
        this.delegate = target;
        return old;
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }
}

