/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.comment.CommentAction;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.pull.PullRequestActivitySearchRequest;
import com.atlassian.stash.pull.PullRequestActivityType;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestActivitySearchCriteria {
    private final Set<CommentAction> commentActions;
    private final Set<Long> commentIds;
    private final long pullRequestId;
    private final Set<Integer> types;

    public PullRequestActivitySearchCriteria(@Nonnull InternalPullRequest pullRequest, @Nonnull PullRequestActivitySearchRequest searchRequest) {
        this(pullRequest.getGlobalId(), PullRequestActivitySearchCriteria.toActivityTypes(searchRequest.getTypes()), searchRequest.getCommentActions(), searchRequest.getCommentIds());
    }

    public PullRequestActivitySearchCriteria(long pullRequestId, @Nonnull Set<Integer> types, @Nullable Set<CommentAction> commentActions, @Nullable Set<Long> commentIds) {
        this.commentActions = commentActions;
        this.commentIds = commentIds;
        this.pullRequestId = pullRequestId;
        this.types = types;
    }

    @Nullable
    public Set<CommentAction> getCommentActions() {
        return this.commentActions;
    }

    @Nullable
    public Set<Long> getCommentIds() {
        return this.commentIds;
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    @Nonnull
    public Set<Integer> getTypes() {
        return this.types;
    }

    private static Set<Integer> toActivityTypes(Set<PullRequestActivityType> types) {
        return ImmutableSet.copyOf((Collection)Collections2.transform(types, (Function)new Function<PullRequestActivityType, Integer>(){

            public Integer apply(PullRequestActivityType type) {
                switch (type) {
                    case COMMENT: {
                        return 2;
                    }
                    case MERGE: {
                        return 3;
                    }
                    case RESCOPE: {
                        return 4;
                    }
                }
                throw new IllegalArgumentException("Unsupported type: " + type);
            }
        }));
    }
}

