define('widget/list-branches-help-dialog', [
    'aui',
    'jquery',
    'lodash'
], function (
    AJS,
    $,
    _
) {

    var dialog;

    function createListBranchesHelpDialog(csid) {
        var dialog = new AJS.Dialog({
            width: 600,
            height: 480,
            id: "list-branches-dialog",
            closeOnOutsideClick: true
        }).addHeader(AJS.I18n.getText('feature.stash.branchInfo.changeset.help.header'));

        dialog.addPanel('',
            feature.stash.branchInfo.changeset.listBranchesHelp({
                csid: csid
            }));

        dialog.addCancel(AJS.I18n.getText('stash.web.button.close'), _.bind(dialog.hide, dialog));

        return dialog;
    }

    function removeDialog() {
        $(document).off('hideLayer', removeDialog);
        if (dialog) {
            dialog.remove();
            dialog = null;
        }
    }

    return {
        showFor: function (csid) {
            removeDialog();
            $(document).on('hideLayer', removeDialog);
            dialog = createListBranchesHelpDialog(csid);
            dialog.show();
            dialog.updateHeight();
        }
    };
});
