define('feature/branch-info/common', [
    'jquery',
    'lodash',
    'stash/api/util/navbuilder',
    'util/ajax',
    'exports'
], function (
    $,
    _,
    nav,
    ajax,
    exports
) {

    var MAX_BRANCHES = 10;

    function getBranchesUrl(csid) {
        return nav.rest('branch-utils').currentRepo()
            .addPathComponents('branches', 'info', csid)
            .withParams({limit: MAX_BRANCHES})
            .build();
    }

    function getCommitsUrl(branch) {
        return nav.currentRepo().commits().withParams(!branch.isDefault ? {until: branch.id} : {}).build();
    }

    exports.queryBranchInfoAndDecorate = function (ctx, placeholderSelector, decorationProvider, errorProvider, onShow) {
        ajax.rest({
            url: getBranchesUrl(ctx.csid),
            statusCode: {
                '500': function () {
                    var $placeholder = $(placeholderSelector);
                    $placeholder.replaceWith(errorProvider({}));
                    return false;
                }
            }
        }).done(function (data) {
                var branches = _.map(data.values, function (ref) {
                    return {
                        url: getCommitsUrl(ref),
                        name: ref.displayId
                    };
                });
                var $placeholder = $(placeholderSelector);

                $placeholder.replaceWith(decorationProvider({
                    branches: branches,
                    more: !data.isLastPage
                }));
                if (onShow) {
                    onShow($placeholder);
                }
            });
    };
});
