/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.restriction.provider;

import com.atlassian.stash.branch.model.BranchModel;
import com.atlassian.stash.branch.model.BranchModelService;
import com.atlassian.stash.branch.model.BranchType;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.branch.model.restriction.matcher.ModelCategoryMatcher;
import com.atlassian.stash.internal.branch.model.restriction.type.ModelCategoryMatcherType;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.ref.restriction.RefMatcher;
import com.atlassian.stash.repository.ref.restriction.RefMatcherProvider;
import com.atlassian.stash.repository.ref.restriction.RefMatcherType;
import com.atlassian.stash.repository.ref.restriction.UnknownRefMatcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ModelCategoryMatcherProvider
implements RefMatcherProvider {
    private static final String MODEL_CATEGORY = "MODEL_CATEGORY";
    private final BranchModelService branchModelService;
    private final I18nService i18nService;

    public ModelCategoryMatcherProvider(BranchModelService branchModelService, I18nService i18nService) {
        this.branchModelService = branchModelService;
        this.i18nService = i18nService;
    }

    @Nullable
    public RefMatcher create(@Nonnull Repository repository, @Nonnull String branchTypeId) {
        BranchModel model = this.branchModelService.getModel(repository);
        if (model == null) {
            return new UnknownRefMatcher.Builder().matcherId(this.i18nService.getText("stash.branchmodel.type." + branchTypeId.toUpperCase(), branchTypeId, new Object[0])).typeId(MODEL_CATEGORY).build();
        }
        for (BranchType type : model.getTypes()) {
            if (!branchTypeId.equals(type.getId())) continue;
            return new ModelCategoryMatcher(type, model);
        }
        return new UnknownRefMatcher.Builder().matcherId(branchTypeId).typeId(MODEL_CATEGORY).build();
    }

    @Nonnull
    public RefMatcherType getType() {
        return ModelCategoryMatcherType.getInstance();
    }
}

