/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.restriction.provider;

import com.atlassian.stash.branch.model.BranchModel;
import com.atlassian.stash.branch.model.BranchModelService;
import com.atlassian.stash.exception.EmptyRepositoryException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.branch.model.restriction.matcher.ModelBranchMatcher;
import com.atlassian.stash.internal.branch.model.restriction.type.ModelBranchMatcherType;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.ref.restriction.RefMatcher;
import com.atlassian.stash.repository.ref.restriction.RefMatcherProvider;
import com.atlassian.stash.repository.ref.restriction.RefMatcherType;
import com.atlassian.stash.repository.ref.restriction.UnknownRefMatcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ModelBranchMatcherProvider
implements RefMatcherProvider {
    private final BranchModelService branchModelService;
    private final I18nService i18nService;

    public ModelBranchMatcherProvider(BranchModelService branchModelService, I18nService i18nService) {
        this.branchModelService = branchModelService;
        this.i18nService = i18nService;
    }

    @Nullable
    public RefMatcher create(@Nonnull Repository repository, @Nonnull String value) {
        BranchModel model = null;
        try {
            model = this.branchModelService.getModel(repository);
        }
        catch (EmptyRepositoryException emptyRepositoryException) {
            // empty catch block
        }
        if (model == null) {
            UnknownRefMatcher unknownSubject = new UnknownRefMatcher.Builder().matcherId(this.i18nService.getText("stash.branchmodel." + value.toUpperCase(), value, new Object[0])).typeId("MODEL_BRANCH").build();
            return unknownSubject;
        }
        return new ModelBranchMatcher(value, this.i18nService.getText("stash.branchmodel." + value.toUpperCase(), value, new Object[0]), model);
    }

    @Nonnull
    public RefMatcherType getType() {
        return ModelBranchMatcherType.getInstance();
    }
}

