/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.restriction.matcher;

import com.atlassian.stash.branch.model.BranchClassifier;
import com.atlassian.stash.branch.model.BranchModel;
import com.atlassian.stash.branch.model.BranchType;
import com.atlassian.stash.internal.branch.model.restriction.type.ModelCategoryMatcherType;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.InternalBranch;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.ref.restriction.AbstractRefMatcher;
import com.atlassian.stash.repository.ref.restriction.RefMatcherType;
import javax.annotation.Nonnull;

public class ModelCategoryMatcher
extends AbstractRefMatcher {
    private final BranchClassifier classifier;
    private final String displayId;

    public ModelCategoryMatcher(BranchType branchType2, BranchModel model) {
        super((RefMatcherType)ModelCategoryMatcherType.getInstance(), branchType2.getId());
        this.displayId = branchType2.getDisplayName();
        this.classifier = model.getClassifier();
    }

    @Nonnull
    public String getDisplayId() {
        return this.displayId;
    }

    public boolean matches(@Nonnull Ref ref) {
        InternalBranch branch = ((InternalBranch.Builder)((InternalBranch.Builder)((InternalBranch.Builder)new InternalBranch.Builder().id(ref.getId())).displayId(ref.getDisplayId())).latestCommit(ref.getLatestCommit())).build();
        BranchType type = this.classifier.getType((Branch)branch);
        return type != null && type.getId().equals(this.getId());
    }
}

