/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.rest;

import com.atlassian.stash.branch.model.BranchModel;
import com.atlassian.stash.branch.model.BranchType;
import com.atlassian.stash.internal.branch.model.rest.RestBranchType;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestBranch;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=BranchModel.class)
public class RestBranchModel
extends RestMapEntity {
    public static final String DEVELOPMENT_BRANCH = "development";
    public static final String PRODUCTION_BRANCH = "production";
    public static final String TYPES = "types";
    public static final RestBranchModel EXAMPLE = new RestBranchModel(RestBranch.RESPONSE_EXAMPLE, RestBranch.RESPONSE_EXAMPLE, (Iterable<RestBranchType>)ImmutableList.of((Object)((Object)RestBranchType.BUGFIX_RESPONSE_EXAMPLE), (Object)((Object)RestBranchType.FEATURE_RESPONSE_EXAMPLE)));

    public RestBranchModel() {
    }

    public RestBranchModel(@Nonnull BranchModel model) {
        this(model.getDevelopment(), model.getProduction(), model.getTypes());
    }

    public RestBranchModel(@Nonnull Branch devBranch, @Nullable Branch prodBranch, @Nonnull Iterable<BranchType> types) {
        this.put(DEVELOPMENT_BRANCH, new RestBranch(devBranch));
        if (prodBranch != null) {
            this.put(PRODUCTION_BRANCH, new RestBranch(prodBranch));
        }
        this.put(TYPES, Iterables.transform(types, RestBranchType.REST_TRANSFORM));
    }

    private RestBranchModel(RestBranch development, RestBranch production, Iterable<RestBranchType> branchTypes) {
        this.put(DEVELOPMENT_BRANCH, development);
        this.putIfNotNull(PRODUCTION_BRANCH, production);
        this.put(TYPES, branchTypes);
    }
}

