/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.configuration;

import com.atlassian.stash.internal.branch.model.BranchTypes;
import com.atlassian.stash.internal.branch.model.configuration.BranchConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.SimpleBranchTypeConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleBranchModelConfiguration
implements BranchModelConfiguration {
    private final BranchConfiguration development;
    private final BranchConfiguration production;
    private final Set<BranchTypeConfiguration> types;

    protected SimpleBranchModelConfiguration(@Nonnull BranchConfiguration development, @Nullable BranchConfiguration production, @Nonnull Set<BranchTypeConfiguration> types) {
        this.development = (BranchConfiguration)Preconditions.checkNotNull((Object)development, (Object)"development");
        this.production = production;
        this.types = ImmutableSet.copyOf((Collection)BranchTypes.DEFAULT_ORDER.immutableSortedCopy(types));
    }

    protected SimpleBranchModelConfiguration(@Nonnull AbstractBuilder<?> builder) {
        this(builder.development, builder.production, (Set<BranchTypeConfiguration>)ImmutableSet.copyOf(builder.types));
    }

    @Override
    @Nonnull
    public BranchConfiguration getDevelopment() {
        return this.development;
    }

    @Override
    @Nullable
    public BranchConfiguration getProduction() {
        return this.production;
    }

    @Override
    @Nonnull
    public Set<BranchTypeConfiguration> getTypes() {
        return this.types;
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        protected BranchConfiguration development;
        protected BranchConfiguration production;
        protected final Set<BranchTypeConfiguration> types = Sets.newTreeSet(BranchTypes.DEFAULT_ORDER);

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(BranchModelConfiguration original) {
            this.development = original.getDevelopment();
            this.production = original.getProduction();
            this.types.addAll(original.getTypes());
        }

        @Nonnull
        public B development(@Nonnull BranchConfiguration development) {
            this.development = (BranchConfiguration)Preconditions.checkNotNull((Object)development, (Object)"development");
            return this.self();
        }

        @Nonnull
        public B production(@Nullable BranchConfiguration production) {
            this.production = production;
            return this.self();
        }

        @Nonnull
        public B types(@Nonnull Iterable<BranchTypeConfiguration> values) {
            Preconditions.checkNotNull(values, (Object)"value");
            for (BranchTypeConfiguration type : values) {
                this.type(type);
            }
            return this.self();
        }

        @Nonnull
        public B types(@Nonnull BranchTypeConfiguration first, BranchTypeConfiguration ... rest) {
            Preconditions.checkNotNull((Object)first, (Object)"first");
            Preconditions.checkNotNull((Object)rest, (Object)"rest");
            this.types(Collections.singleton(first));
            return this.types(Arrays.asList(rest));
        }

        @Nonnull
        public B type(@Nonnull BranchTypeConfiguration value) {
            Preconditions.checkNotNull((Object)value, (Object)"value");
            if (this.types.contains(value)) {
                this.types.remove(value);
            }
            this.types.add(value);
            return this.self();
        }

        @Nonnull
        public B type(@Nonnull String id, @Nullable String prefix, boolean enabled) {
            return this.type(new SimpleBranchTypeConfiguration(BranchTypes.forId(id), enabled, prefix));
        }

        @Nonnull
        public B enabledType(@Nonnull String id, @Nonnull String prefix) {
            return this.type(id, prefix, true);
        }

        protected abstract B self();
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        public Builder() {
        }

        public Builder(BranchModelConfiguration original) {
            super(original);
        }

        public SimpleBranchModelConfiguration build() {
            return new SimpleBranchModelConfiguration(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

