/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model;

import com.atlassian.stash.branch.model.BranchClassifier;
import com.atlassian.stash.branch.model.BranchType;
import com.atlassian.stash.internal.branch.model.InternalBranchType;
import com.atlassian.stash.internal.branch.model.InternalBranchTypes;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.MinimalRef;
import com.atlassian.stash.repository.RefOrder;
import com.atlassian.stash.repository.RefService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryBranchesRequest;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.PagedIterable;
import com.atlassian.stash.util.PredicateUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrefixBranchClassifier
implements BranchClassifier {
    private static final int BRANCHES_PER_PAGE = 1000;
    private final RefService refService;
    private final Repository repository;
    private final Iterable<InternalBranchType> types;

    public PrefixBranchClassifier(@Nonnull RefService refService, @Nonnull Repository repository, @Nonnull Iterable<InternalBranchType> types) {
        this.refService = (RefService)Preconditions.checkNotNull((Object)refService, (Object)"refService");
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
        this.types = (Iterable)Preconditions.checkNotNull(types, (Object)"types");
    }

    @Override
    @Nullable
    public InternalBranchType getType(final @Nonnull Branch branch) {
        Preconditions.checkNotNull((Object)branch, (Object)"branch");
        return (InternalBranchType)Iterables.find(this.types, (Predicate)new Predicate<InternalBranchType>(){

            public boolean apply(InternalBranchType input) {
                return branch.getDisplayId().startsWith(input.getPrefix());
            }
        }, null);
    }

    @Override
    @Nonnull
    public Iterable<Branch> getAllBranchesByType(final @Nonnull BranchType branchType2) {
        return new PagedIterable((PageProvider)new PageProvider<Branch>(){

            public Page<Branch> get(PageRequest request) {
                return PrefixBranchClassifier.this.getBranchesByType(branchType2, request);
            }
        }, 1000);
    }

    @Override
    @Nonnull
    public Page<Branch> getBranchesByType(@Nonnull BranchType branchType2, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)branchType2, (Object)"branchType");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        if (!Iterables.contains(this.types, (Object)branchType2)) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return this.getPageForType(branchType2, pageRequest);
    }

    private Page<Branch> getPageForType(BranchType branchType2, PageRequest pageRequest) {
        final InternalBranchType internalBranchType = InternalBranchTypes.asInternalBranchType(branchType2);
        PageProvider<Branch> branchesProvider = new PageProvider<Branch>(){

            public Page<Branch> get(PageRequest request) {
                return PrefixBranchClassifier.this.refService.getBranches(new RepositoryBranchesRequest.Builder(PrefixBranchClassifier.this.repository).filterText(internalBranchType.getPrefix()).order(RefOrder.ALPHABETICAL).build(), request);
            }
        };
        Predicate startsWithPrefix = Predicates.compose((Predicate)PredicateUtils.startsWith((String)internalBranchType.getPrefix()), (Function)MinimalRef.TO_DISPLAY_ID);
        return PageUtils.filterPages((PageProvider)branchesProvider, (Predicate)startsWithPrefix, (PageRequest)pageRequest);
    }
}

