/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.stash.branch.model.BranchModel;
import com.atlassian.stash.branch.model.BranchModelService;
import com.atlassian.stash.branch.model.BranchType;
import com.atlassian.stash.event.RepositoryCreatedEvent;
import com.atlassian.stash.event.RepositoryDeletedEvent;
import com.atlassian.stash.exception.EmptyRepositoryException;
import com.atlassian.stash.exception.InvalidRefNameException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.branch.model.InternalBranchType;
import com.atlassian.stash.internal.branch.model.InternalBranchTypes;
import com.atlassian.stash.internal.branch.model.PrefixBranchClassifier;
import com.atlassian.stash.internal.branch.model.SimpleBranchModel;
import com.atlassian.stash.internal.branch.model.SimpleInternalBranchType;
import com.atlassian.stash.internal.branch.model.configuration.BranchConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.BranchModelConfigurationRequest;
import com.atlassian.stash.internal.branch.model.configuration.BranchModelConfigurationService;
import com.atlassian.stash.internal.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.SimpleBranchConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.SimpleBranchModelConfiguration;
import com.atlassian.stash.internal.branch.model.configuration.SimpleBranchTypeConfiguration;
import com.atlassian.stash.internal.branch.model.dao.BranchModelDao;
import com.atlassian.stash.internal.branch.model.dao.PersistentBranchModelConfiguration;
import com.atlassian.stash.internal.branch.model.exception.BranchModelConfigurationException;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.RefService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.repository.ref.restriction.RefRestrictionService;
import com.atlassian.stash.scm.git.GitScm;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionValidationService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBranchModelService
implements BranchModelService,
BranchModelConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultBranchModelService.class);
    private static final String BRANCHMODEL_PROP_PREFIX = "plugin.stash-branch-model.";
    private static final int DEFAULT_PREFIX_MAX_LENGTH = 30;
    static final String PROP_PREFIX_MAX_LENGTH = "plugin.stash-branch-model.validation.prefix.length";
    public static final String DEFAULT_VERSION_COMPONENT_SEPARATOR = "[_\\-.+]";
    static final String PROP_VERSION_COMPONENT_SEPARATOR = "plugin.stash-branch-model.version.separator";
    private static final String DEVELOPMENT_ID = "DEVELOPMENT";
    private static final String PRODUCTION_ID = "PRODUCTION";
    private static final Integer NUMBER_BRANCH_MODEL_SETTINGS = 5;
    private static final Integer NUMBER_BRANCH_PERMISSIONS = 4;
    private final ActiveObjects ao;
    private final ApplicationPropertiesService applicationPropertiesService;
    private final BranchModelDao branchModelDao;
    private final GitScm gitScm;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final RefRestrictionService refRestrictionService;
    private final RefService refService;
    private final RepositoryService repositoryService;

    public DefaultBranchModelService(ActiveObjects ao, ApplicationPropertiesService applicationPropertiesService, BranchModelDao branchModelDao, GitScm gitScm, I18nService i18nService, PermissionValidationService permissionValidationService, RefRestrictionService refRestrictionService, RefService refService, RepositoryService repositoryService) {
        this.ao = ao;
        this.applicationPropertiesService = applicationPropertiesService;
        this.branchModelDao = branchModelDao;
        this.gitScm = gitScm;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.refRestrictionService = refRestrictionService;
        this.refService = refService;
        this.repositoryService = repositoryService;
    }

    @Override
    @Nullable
    public BranchModel getModel(final @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        return (BranchModel)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<BranchModel>(){

            public BranchModel doInTransaction() {
                DefaultBranchModelService.this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ);
                if (DefaultBranchModelService.this.repositoryService.isEmpty(repository)) {
                    throw new EmptyRepositoryException(DefaultBranchModelService.this.i18nService.createKeyedMessage("stash.branchmodel.error.emptyrepository", new Object[]{repository}));
                }
                return DefaultBranchModelService.this.toBranchModel(DefaultBranchModelService.this.branchModelDao.getByRepository(repository), repository);
            }
        });
    }

    @Override
    @Nullable
    public BranchModelConfiguration getConfiguration(final @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        return (BranchModelConfiguration)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<BranchModelConfiguration>(){

            public BranchModelConfiguration doInTransaction() {
                DefaultBranchModelService.this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
                return DefaultBranchModelService.this.getByRepository(repository);
            }
        });
    }

    @Override
    @Nonnull
    public BranchModelConfiguration getDefaultConfiguration() {
        return ((SimpleBranchModelConfiguration.Builder)((SimpleBranchModelConfiguration.Builder)((SimpleBranchModelConfiguration.Builder)((SimpleBranchModelConfiguration.Builder)((SimpleBranchModelConfiguration.Builder)new SimpleBranchModelConfiguration.Builder().development(new SimpleBranchConfiguration(null, true))).enabledType(InternalBranchTypes.BUGFIX.getId(), InternalBranchTypes.BUGFIX.getDefaultPrefix())).enabledType(InternalBranchTypes.FEATURE.getId(), InternalBranchTypes.FEATURE.getDefaultPrefix())).enabledType(InternalBranchTypes.HOTFIX.getId(), InternalBranchTypes.HOTFIX.getDefaultPrefix())).enabledType(InternalBranchTypes.RELEASE.getId(), InternalBranchTypes.RELEASE.getDefaultPrefix())).build();
    }

    @Override
    public boolean setEnabled(final @Nonnull Repository repository, final boolean enabled) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        return (Boolean)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction() {
                DefaultBranchModelService.this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
                PersistentBranchModelConfiguration branchModelConfig = DefaultBranchModelService.this.branchModelDao.getByRepository(repository);
                if (branchModelConfig == null && enabled) {
                    DefaultBranchModelService.this.createDefaultModel(repository);
                    return true;
                }
                if (branchModelConfig != null) {
                    return DefaultBranchModelService.this.branchModelDao.setEnabled(repository, enabled);
                }
                return false;
            }
        });
    }

    @Override
    @Nonnull
    public BranchModelConfiguration updateConfiguration(final @Nonnull Repository repository, final @Nonnull BranchModelConfigurationRequest updateRequest) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)updateRequest, (Object)"updateRequest");
        return (BranchModelConfiguration)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<BranchModelConfiguration>(){

            public BranchModelConfiguration doInTransaction() {
                DefaultBranchModelService.this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
                PersistentBranchModelConfiguration model = DefaultBranchModelService.this.branchModelDao.getByRepository(repository);
                if (model == null || !model.isEnabled()) {
                    throw new NoSuchEntityException(DefaultBranchModelService.this.i18nService.createKeyedMessage("stash.branchmodel.error.nosuchbranchmodel", new Object[]{repository}));
                }
                DefaultBranchModelService.this.validate(repository, updateRequest);
                DefaultBranchModelService.this.branchModelDao.update(repository, updateRequest);
                return DefaultBranchModelService.this.getByRepository(repository);
            }
        });
    }

    @EventListener
    public void onRepositoryCreated(final @Nonnull RepositoryCreatedEvent repositoryCreatedEvent) {
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                DefaultBranchModelService.this.createDefaultModel(repositoryCreatedEvent.getRepository());
                return null;
            }
        });
    }

    @EventListener
    public void onRepositoryDeleted(final @Nonnull RepositoryDeletedEvent repositoryDeletedEvent) {
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                DefaultBranchModelService.this.branchModelDao.deleteByRepository(repositoryDeletedEvent.getRepository());
                return null;
            }
        });
    }

    private String getBranchId(BranchConfiguration branchConfiguration, Repository repository) {
        if (branchConfiguration == null) {
            return null;
        }
        if (branchConfiguration.isUseDefault()) {
            return this.refService.getDefaultBranch(repository).getId();
        }
        return branchConfiguration.getRefId();
    }

    private BranchModelConfiguration addI18nedDisplayNames(BranchModelConfiguration originalModel) {
        ImmutableSet.Builder i18nedTypes = ImmutableSet.builder();
        for (BranchTypeConfiguration originalType : originalModel.getTypes()) {
            InternalBranchTypes internalType = InternalBranchTypes.forId(originalType.getId());
            i18nedTypes.add((Object)new SimpleBranchTypeConfiguration(internalType.getType(), internalType.getDisplayName(this.i18nService), originalType.isEnabled(), originalType.getPrefix()));
        }
        return ((SimpleBranchModelConfiguration.Builder)((SimpleBranchModelConfiguration.Builder)((SimpleBranchModelConfiguration.Builder)new SimpleBranchModelConfiguration.Builder().development(originalModel.getDevelopment())).production(originalModel.getProduction())).types((Iterable<BranchTypeConfiguration>)i18nedTypes.build())).build();
    }

    private void createDefaultModel(Repository repository) {
        this.branchModelDao.create(repository, new BranchModelConfigurationRequest.Builder(this.getDefaultConfiguration()).build());
    }

    private BranchModelConfiguration getByRepository(Repository repository) {
        PersistentBranchModelConfiguration configuration = this.branchModelDao.getByRepository(repository);
        if (configuration == null || !configuration.isEnabled()) {
            return null;
        }
        return this.addI18nedDisplayNames(configuration);
    }

    private Set<InternalBranchType> getEffectiveTypes(PersistentBranchModelConfiguration model) {
        ImmutableSet.Builder types = ImmutableSet.builder();
        for (BranchTypeConfiguration typeConfiguration : model.getTypes()) {
            if (!typeConfiguration.isEnabled()) continue;
            InternalBranchTypes internalType = InternalBranchTypes.forId(typeConfiguration.getId());
            types.add((Object)new SimpleInternalBranchType(internalType.getType(), internalType.getDisplayName(this.i18nService), typeConfiguration.getPrefix()));
        }
        return types.build();
    }

    private Branch getDevelopmentBranch(PersistentBranchModelConfiguration configuration, Repository repository) {
        if (configuration.getDevelopment().isUseDefault()) {
            return this.refService.getDefaultBranch(repository);
        }
        Ref ref = this.refService.resolveRef(repository, configuration.getDevelopment().getRefId());
        if (this.isNotBranch(ref)) {
            log.debug("Ref {} stored as development branch for repository {} does not resolve to a branch", (Object)configuration.getDevelopment().getRefId(), (Object)repository);
            return this.refService.getDefaultBranch(repository);
        }
        return (Branch)ref;
    }

    private Branch getProductionBranch(PersistentBranchModelConfiguration configuration, Repository repository) {
        if (configuration.getProduction() == null) {
            return null;
        }
        if (configuration.getProduction().isUseDefault()) {
            return this.refService.getDefaultBranch(repository);
        }
        Ref ref = this.refService.resolveRef(repository, configuration.getProduction().getRefId());
        if (this.isNotBranch(ref)) {
            log.debug("Ref {} stored as production branch for repository {} does not resolve to a branch", (Object)configuration.getProduction().getRefId(), (Object)repository);
            return null;
        }
        return (Branch)ref;
    }

    private boolean isNotBranch(Ref ref) {
        return ref == null || !Branch.class.isInstance(ref);
    }

    private BranchModel toBranchModel(PersistentBranchModelConfiguration configuration, Repository repository) {
        if (configuration == null || !configuration.isEnabled()) {
            return null;
        }
        Set<BranchType> types = this.getEffectiveTypes(configuration);
        return new SimpleBranchModel.Builder().development(this.getDevelopmentBranch(configuration, repository)).production(this.getProductionBranch(configuration, repository)).types(types).classifier(new PrefixBranchClassifier(this.refService, repository, types)).versionComponentSeparators(this.getVersionComponentSeparators()).build();
    }

    private void validate(Repository repository, BranchModelConfigurationRequest updateRequest) {
        this.validateDevelopment(repository, updateRequest);
        this.validateProduction(repository, updateRequest);
        this.validatePrefixes(repository, updateRequest);
    }

    private void validateDevelopment(Repository repository, BranchModelConfigurationRequest updateRequest) {
        this.validateBranchConfiguration(repository, updateRequest.getDevelopment(), DEVELOPMENT_ID);
    }

    private void validateProduction(Repository repository, BranchModelConfigurationRequest updateRequest) {
        if (updateRequest.getProduction() != null) {
            this.validateBranchConfiguration(repository, updateRequest.getProduction(), PRODUCTION_ID);
        }
    }

    private void validateBranchConfiguration(Repository repository, BranchConfiguration config, String branchTypeId) {
        if (StringUtils.isEmpty((String)config.getRefId()) && !config.isUseDefault()) {
            throw new BranchModelConfigurationException(this.i18nService.createKeyedMessage("stash.branchmodel.error.invalidBranchConfiguration", new Object[]{this.getBranchI18nName(branchTypeId)}), branchTypeId, new String[0]);
        }
        if (!config.isUseDefault() && StringUtils.isNotEmpty((String)config.getRefId())) {
            this.validateRefId(repository, config.getRefId(), branchTypeId);
        }
    }

    private void validateNoOverlap(BranchTypeConfiguration first, BranchTypeConfiguration second) {
        String secondPrefix;
        String firstPrefix = first.getPrefix();
        if (firstPrefix.startsWith(secondPrefix = second.getPrefix()) || secondPrefix.startsWith(firstPrefix)) {
            throw new BranchModelConfigurationException(this.i18nService.createKeyedMessage("stash.branchmodel.error.prefixoverlap", new Object[]{firstPrefix, secondPrefix}), first.getId(), second.getId());
        }
    }

    private void validatePrefixes(Repository repository, BranchModelConfigurationRequest updateRequest) {
        List<BranchTypeConfiguration> enabledTypes = this.getEnabledTypes(updateRequest);
        for (BranchTypeConfiguration typeConfiguration : enabledTypes) {
            this.validatePrefixNonEmpty(typeConfiguration);
            this.validatePrefixLength(typeConfiguration);
            if (!"git".equals(repository.getScmId())) continue;
            this.validateGitPrefix(typeConfiguration);
        }
        for (int i = 0; i < enabledTypes.size(); ++i) {
            for (int j = i + 1; j < enabledTypes.size(); ++j) {
                this.validateNoOverlap(enabledTypes.get(i), enabledTypes.get(j));
            }
        }
    }

    private void validatePrefixLength(BranchTypeConfiguration typeConfiguration) {
        int prefixMaxLength = this.getBranchPrefixLimit();
        if (typeConfiguration.getPrefix().length() > prefixMaxLength) {
            throw new BranchModelConfigurationException(this.i18nService.createKeyedMessage("stash.branchmodel.error.prefixtoolong", new Object[]{typeConfiguration.getPrefix(), prefixMaxLength}), typeConfiguration.getId(), new String[0]);
        }
    }

    private void validatePrefixNonEmpty(BranchTypeConfiguration typeConfiguration) {
        if (StringUtils.isBlank((String)typeConfiguration.getPrefix())) {
            throw new BranchModelConfigurationException(this.i18nService.createKeyedMessage("stash.branchmodel.error.emptyprefix", new Object[0]), typeConfiguration.getId(), new String[0]);
        }
    }

    private void validateGitPrefix(BranchTypeConfiguration typeConfiguration) {
        try {
            this.gitScm.validateRefName(typeConfiguration.getPrefix() + "a");
        }
        catch (InvalidRefNameException e) {
            throw new BranchModelConfigurationException(this.i18nService.createKeyedMessage("stash.branchmodel.error.invalidgitprefix", new Object[]{typeConfiguration.getPrefix()}), typeConfiguration.getId(), new String[0]);
        }
    }

    private void validateRefId(Repository repository, String refId, String branchTypeId) {
        if (this.isNotBranch(this.refService.resolveRef(repository, refId))) {
            throw new InvalidRefNameException(this.i18nService.createKeyedMessage("stash.branchmodel.error.invalidBranchId", new Object[]{refId, this.getBranchI18nName(branchTypeId)}), refId);
        }
    }

    private List<BranchTypeConfiguration> getEnabledTypes(BranchModelConfigurationRequest updateRequest) {
        return ImmutableList.copyOf((Collection)Sets.filter(updateRequest.getTypes(), BranchTypeConfiguration.IS_ENABLED));
    }

    private String getBranchI18nName(String branchId) {
        return this.i18nService.getMessage("stash.branchmodel." + branchId, new Object[0]);
    }

    private String getVersionComponentSeparators() {
        return this.applicationPropertiesService.getPluginProperty(PROP_VERSION_COMPONENT_SEPARATOR, DEFAULT_VERSION_COMPONENT_SEPARATOR);
    }

    private int getBranchPrefixLimit() {
        return this.applicationPropertiesService.getPluginProperty(PROP_PREFIX_MAX_LENGTH, 30);
    }
}

