/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model;

import com.atlassian.stash.branch.model.BranchType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Ordering;
import javax.annotation.Nonnull;

public enum BranchTypes {
    BUGFIX,
    FEATURE,
    HOTFIX,
    RELEASE;

    public static final Ordering<BranchType> DEFAULT_ORDER;

    public static BranchTypes forId(@Nonnull String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        return BranchTypes.valueOf(id.toUpperCase());
    }

    public String getId() {
        return this.name();
    }

    public Predicate<BranchType> matcher() {
        return new Predicate<BranchType>(){

            public boolean apply(BranchType branchType2) {
                return branchType2 != null && BranchTypes.this.getId().equals(branchType2.getId().toUpperCase());
            }
        };
    }

    static {
        DEFAULT_ORDER = Ordering.natural().onResultOf((Function)new Function<BranchType, BranchTypes>(){

            public BranchTypes apply(BranchType type) {
                return BranchTypes.forId(type.getId());
            }
        });
    }
}

