/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.list.aheadbehind;

import com.atlassian.stash.commit.CommitService;
import com.atlassian.stash.commit.graph.TraversalCallback;
import com.atlassian.stash.commit.graph.TraversalRequest;
import com.atlassian.stash.internal.branch.list.aheadbehind.AheadBehindCount;
import com.atlassian.stash.internal.branch.list.aheadbehind.BatchingAheadBehindTraversalCallback;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.RefMetadataContext;
import com.atlassian.stash.repository.RefMetadataProvider;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;

public class AheadBehindRefMetadataProvider
implements RefMetadataProvider<AheadBehindCount> {
    private final CommitService commitService;

    public AheadBehindRefMetadataProvider(CommitService commitService) {
        this.commitService = commitService;
    }

    @Nonnull
    public Map<Ref, AheadBehindCount> getMetadata(@Nonnull RefMetadataContext context) {
        HashSet refs = Sets.newHashSet((Iterable)context.getRefs());
        refs.remove(context.getBaseRef());
        if (refs.isEmpty()) {
            return Collections.emptyMap();
        }
        BatchingAheadBehindTraversalCallback callback = BatchingAheadBehindTraversalCallback.create(context.getBaseRef(), refs);
        this.commitService.traverse(new TraversalRequest.Builder().repository(context.getRepository()).include(Iterables.transform((Iterable)Iterables.concat((Iterable)refs, Collections.singleton(context.getBaseRef())), (Function)Ref.TO_LATEST_COMMIT)).build(), (TraversalCallback)callback);
        return callback.get();
    }
}

