/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch;

import com.atlassian.stash.branch.model.BranchModel;
import com.atlassian.stash.branch.model.BranchModelService;
import com.atlassian.stash.branch.model.BranchType;
import com.atlassian.stash.internal.branch.BranchModelUtils$;
import com.atlassian.stash.internal.branch.MergeConflictPropertyProvider$;
import com.atlassian.stash.internal.branch.automerge.AutoMerge;
import com.atlassian.stash.internal.branch.automerge.AutoMergeService;
import com.atlassian.stash.internal.branch.model.BranchTypes;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestMergeability;
import com.atlassian.stash.pull.PullRequestMergeabilityPropertyProvider;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.Ref;
import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nonnull;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u00015\u0011Q$T3sO\u0016\u001cuN\u001c4mS\u000e$\bK]8qKJ$\u0018\u0010\u0015:pm&$WM\u001d\u0006\u0003\u0007\u0011\taA\u0019:b]\u000eD'BA\u0003\u0007\u0003!Ig\u000e^3s]\u0006d'BA\u0004\t\u0003\u0015\u0019H/Y:i\u0015\tI!\"A\u0005bi2\f7o]5b]*\t1\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u001dY\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0019\tA\u0001];mY&\u00111\u0004\u0007\u0002(!VdGNU3rk\u0016\u001cH/T3sO\u0016\f'-\u001b7jif\u0004&o\u001c9feRL\bK]8wS\u0012,'\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003A\tW\u000f^8NKJ<WmU3sm&\u001cW\r\u0005\u0002 E5\t\u0001E\u0003\u0002\"\u0005\u0005I\u0011-\u001e;p[\u0016\u0014x-Z\u0005\u0003G\u0001\u0012\u0001#Q;u_6+'oZ3TKJ4\u0018nY3\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019\n!C\u0019:b]\u000eDWj\u001c3fYN+'O^5dKB\u0011qeK\u0007\u0002Q)\u0011\u0011FK\u0001\u0006[>$W\r\u001c\u0006\u0003\u0007\u0019I!\u0001\f\u0015\u0003%\t\u0013\u0018M\\2i\u001b>$W\r\\*feZL7-\u001a\u0005\u0006]\u0001!\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007A\u00124\u0007\u0005\u00022\u00015\t!\u0001C\u0003\u001e[\u0001\u0007a\u0004C\u0003&[\u0001\u0007a\u0005C\u00036\u0001\u0011\u0005c'A\tqe>4\u0018\u000eZ3Qe>\u0004XM\u001d;jKN$2aN$V!\u0011A4(\u0010\b\u000e\u0003eR!A\u000f\n\u0002\tU$\u0018\u000e\\\u0005\u0003ye\u00121!T1q!\tqDI\u0004\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000b\u001a\u0013aa\u0015;sS:<'BA\"A\u0011\u0015AE\u00071\u0001J\u0003-\u0001X\u000f\u001c7SKF,Xm\u001d;\u0011\u0005]Q\u0015BA&\u0019\u0005-\u0001V\u000f\u001c7SKF,Xm\u001d;)\u0005\u001dk\u0005C\u0001(T\u001b\u0005y%B\u0001)R\u0003)\tgN\\8uCRLwN\u001c\u0006\u0002%\u0006)!.\u0019<bq&\u0011Ak\u0014\u0002\b\u001d>tg.\u001e7m\u0011\u00151F\u00071\u0001X\u00031iWM]4fC\nLG.\u001b;z!\t9\u0002,\u0003\u0002Z1\t9\u0002+\u001e7m%\u0016\fX/Z:u\u001b\u0016\u0014x-Z1cS2LG/\u001f\u0015\u0003+6C#\u0001N'\t\u000bu\u0003A\u0011\u00020\u0002'%\u001c\u0018)\u001e;p\u001b\u0016\u0014x-Z\"p]\u001ad\u0017n\u0019;\u0015\u0005}\u0013\u0007CA a\u0013\t\t\u0007IA\u0004C_>dW-\u00198\t\u000b!c\u0006\u0019A%\t\u000b\u0011\u0004A\u0011B3\u0002\u0011%\u001c8\u000b^1cY\u0016$2a\u00184k\u0011\u0015I3\r1\u0001h!\t9\u0003.\u0003\u0002jQ\tY!I]1oG\"lu\u000eZ3m\u0011\u0015\u00191\r1\u0001l!\taw.D\u0001n\u0015\tqg!\u0001\u0006sKB|7/\u001b;pefL!\u0001]7\u0003\r\t\u0013\u0018M\\2i\u0011\u0015\u0011\b\u0001\"\u0003t\u0003)I7/\u00168ti\u0006\u0014G.\u001a\u000b\u0004?R,\b\"B\u0015r\u0001\u00049\u0007\"B\u0002r\u0001\u0004Y\u0007\"B<\u0001\t\u0013A\u0018A\b9s_ZLG-Z*pkJ\u001cWm\u0015;bE&d\u0017\u000e^=Qe>\u0004XM\u001d;z)\tI8\u0010\u0005\u0003?uvr\u0011B\u0001\u001fG\u0011\u0015Ae\u000f1\u0001J\u000f\u0015i(\u0001#\u0001\u007f\u0003uiUM]4f\u0007>tg\r\\5diB\u0013x\u000e]3sif\u0004&o\u001c<jI\u0016\u0014\bCA\u0019\u0000\r\u0019\t!\u0001#\u0001\u0002\u0002M\u0019q0a\u0001\u0011\u0007}\n)!C\u0002\u0002\b\u0001\u0013a!\u00118z%\u00164\u0007B\u0002\u0018\u0000\t\u0003\tY\u0001F\u0001\u007f\u0011%\tya b\u0001\n\u0003\t\t\"A\u0006Q%>\u0003v\f\u0015*F\r&CVCAA\n!\ry\u0011QC\u0005\u0003\u000bBA\u0001\"!\u0007\u0000A\u0003%\u00111C\u0001\r!J{\u0005k\u0018)S\u000b\u001aK\u0005\f\t\u0005\n\u0003;y(\u0019!C\u0001\u0003#\t\u0001\u0004\u0015*P!~\u000bU\u000bV(`\u001b\u0016\u0013v)R0D\u001f:3E*S\"U\u0011!\t\tc Q\u0001\n\u0005M\u0011!\u0007)S\u001fB{\u0016)\u0016+P?6+%kR#`\u0007>se\tT%D)\u0002B\u0011\"!\n\u0000\u0005\u0004%\t!!\u0005\u00029A\u0013v\nU0T\u001fV\u00136)R0C%\u0006s5\tS0T)\u0006\u0013\u0015\nT%U3\"A\u0011\u0011F@!\u0002\u0013\t\u0019\"A\u000fQ%>\u0003vlU(V%\u000e+uL\u0011*B\u001d\u000eCul\u0015+B\u0005&c\u0015\nV-!\u0001")
public class MergeConflictPropertyProvider
implements PullRequestMergeabilityPropertyProvider {
    private final AutoMergeService autoMergeService;
    private final BranchModelService branchModelService;

    public static String PROP_SOURCE_BRANCH_STABILITY() {
        return MergeConflictPropertyProvider$.MODULE$.PROP_SOURCE_BRANCH_STABILITY();
    }

    public static String PROP_AUTO_MERGE_CONFLICT() {
        return MergeConflictPropertyProvider$.MODULE$.PROP_AUTO_MERGE_CONFLICT();
    }

    public static String PROP_PREFIX() {
        return MergeConflictPropertyProvider$.MODULE$.PROP_PREFIX();
    }

    @Nonnull
    public java.util.Map<String, Object> provideProperties(@Nonnull PullRequest pullRequest, @Nonnull PullRequestMergeability mergeability) {
        PullRequestMergeability m;
        boolean autoMergeConflict = mergeability.isConflicted() && this.isAutoMergeConflict(pullRequest);
        Tuple2 tuple2 = new Tuple2((Object)pullRequest, (Object)mergeability);
        java.util.Map map = tuple2 != null && !(m = (PullRequestMergeability)tuple2._2()).isConflicted() ? Collections.emptyMap() : (tuple2 != null && autoMergeConflict ? JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)MergeConflictPropertyProvider$.MODULE$.PROP_AUTO_MERGE_CONFLICT()), (Object)Boolean.TRUE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)MergeConflictPropertyProvider$.MODULE$.PROP_SOURCE_BRANCH_STABILITY()), (Object)"stable")}))) : JavaConversions$.MODULE$.mapAsJavaMap(this.provideSourceStabilityProperty(pullRequest)));
        return map;
    }

    private boolean isAutoMergeConflict(PullRequest pullRequest) {
        if (pullRequest.isCrossRepository()) {
            return false;
        }
        AutoMerge autoMerge2 = this.autoMergeService.getAutoMerge(pullRequest.getFromRef().getRepository(), (Ref)pullRequest.getFromRef());
        Branch nextBranch = (Branch)Iterables.get(autoMerge2.getPath(), (int)1, null);
        return nextBranch != null && nextBranch.getId().equals(pullRequest.getToRef().getId());
    }

    private boolean isStable(BranchModel model, Branch branch) {
        BranchType branchType2 = model.getClassifier().getType(branch);
        return BranchTypes.RELEASE.matcher().apply((Object)branchType2) || branch.equals(model.getDevelopment()) || branch.equals(model.getProduction());
    }

    private boolean isUnstable(BranchModel model, Branch branch) {
        BranchType branchType2 = model.getClassifier().getType(branch);
        return BranchTypes.BUGFIX.matcher().apply((Object)branchType2) || BranchTypes.HOTFIX.matcher().apply((Object)branchType2) || BranchTypes.FEATURE.matcher().apply((Object)branchType2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private scala.collection.immutable.Map<String, Object> provideSourceStabilityProperty(PullRequest pullRequest) {
        boolean bl = false;
        Some some = null;
        Option option = Option$.MODULE$.apply((Object)this.branchModelService.getModel(pullRequest.getFromRef().getRepository()));
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            BranchModel model = (BranchModel)some.x();
            if (this.isUnstable(model, BranchModelUtils$.MODULE$.convertRefToBranch((Ref)pullRequest.getFromRef()))) {
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)MergeConflictPropertyProvider$.MODULE$.PROP_SOURCE_BRANCH_STABILITY()), (Object)"unstable")}));
            }
        }
        if (!bl) return Predef$.MODULE$.Map().empty();
        BranchModel model = (BranchModel)some.x();
        if (!this.isStable(model, BranchModelUtils$.MODULE$.convertRefToBranch((Ref)pullRequest.getFromRef()))) return Predef$.MODULE$.Map().empty();
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)MergeConflictPropertyProvider$.MODULE$.PROP_SOURCE_BRANCH_STABILITY()), (Object)"stable")}));
    }

    public MergeConflictPropertyProvider(AutoMergeService autoMergeService, BranchModelService branchModelService) {
        this.autoMergeService = autoMergeService;
        this.branchModelService = branchModelService;
    }
}

