/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.branch.BranchCreatedEvent;
import com.atlassian.stash.branch.BranchCreationCanceledException;
import com.atlassian.stash.branch.BranchCreationRequestedEvent;
import com.atlassian.stash.branch.BranchDeletedEvent;
import com.atlassian.stash.branch.BranchDeletionCanceledException;
import com.atlassian.stash.branch.BranchDeletionRequestedEvent;
import com.atlassian.stash.exception.CommandFailedException;
import com.atlassian.stash.exception.ForbiddenException;
import com.atlassian.stash.exception.InvalidRefNameException;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.branch.BranchHasMovedException;
import com.atlassian.stash.internal.branch.BranchService;
import com.atlassian.stash.internal.branch.BranchStartPointValidationException;
import com.atlassian.stash.internal.branch.DefaultBranchService$;
import com.atlassian.stash.internal.branch.UnsupportedOnBranchException;
import com.atlassian.stash.pull.PullRequestDirection;
import com.atlassian.stash.pull.PullRequestSearchRequest;
import com.atlassian.stash.pull.PullRequestService;
import com.atlassian.stash.pull.PullRequestState;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.IllegalRepositoryStateException;
import com.atlassian.stash.repository.InternalBranch;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.git.GitAgent;
import com.atlassian.stash.scm.git.GitCommandBuilderFactory;
import com.atlassian.stash.scm.git.GitRefPattern;
import com.atlassian.stash.scm.git.GitScm;
import com.atlassian.stash.scm.git.updateref.GitUpdateRefDeleteBuilder;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.util.CancelState;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.SimpleCancelState;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mx!B\u0001\u0003\u0011\u0003i\u0011\u0001\u0006#fM\u0006,H\u000e\u001e\"sC:\u001c\u0007nU3sm&\u001cWM\u0003\u0002\u0004\t\u00051!M]1oG\"T!!\u0002\u0004\u0002\u0011%tG/\u001a:oC2T!a\u0002\u0005\u0002\u000bM$\u0018m\u001d5\u000b\u0005%Q\u0011!C1uY\u0006\u001c8/[1o\u0015\u0005Y\u0011aA2p[\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"\u0001\u0006#fM\u0006,H\u000e\u001e\"sC:\u001c\u0007nU3sm&\u001cWm\u0005\u0002\u0010%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aDQ!G\b\u0005\u0002i\ta\u0001P5oSRtD#A\u0007\t\u000fqy!\u0019!C\u0001;\u0005!R*\u0011-`\rF{&IU!O\u0007\"{F*\u0012(H)\"+\u0012A\b\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA\u0001\\1oO*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u001dIe\u000e^3hKJDaaJ\b!\u0002\u0013q\u0012!F'B1~3\u0015k\u0018\"S\u0003:\u001b\u0005j\u0018'F\u001d\u001e#\u0006\n\t\u0005\bS=\u0011\r\u0011\"\u0001\u001e\u0003ei\u0015\tW0C%\u0006s5\tS0T\u000b\u001ekUI\u0014+`\u0019\u0016su\t\u0016%\t\r-z\u0001\u0015!\u0003\u001f\u0003ii\u0015\tW0C%\u0006s5\tS0T\u000b\u001ekUI\u0014+`\u0019\u0016su\t\u0016%!\u0011\u001disB1A\u0005\u00029\n1\u0001\\8h+\u0005y\u0003C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005!\u0014aA8sO&\u0011a'\r\u0002\u0007\u0019><w-\u001a:\t\raz\u0001\u0015!\u00030\u0003\u0011awn\u001a\u0011\u0007\tA\u0011\u0001AO\n\u0004smr\u0004CA\u0010=\u0013\ti\u0004E\u0001\u0004PE*,7\r\u001e\t\u0003\u001d}J!\u0001\u0011\u0002\u0003\u001b\t\u0013\u0018M\\2i'\u0016\u0014h/[2f\u0011!\u0011\u0015H!A!\u0002\u0013\u0019\u0015\u0001C4ji\u0006;WM\u001c;\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015aA4ji*\u0011\u0001JB\u0001\u0004g\u000el\u0017B\u0001&F\u0005!9\u0015\u000e^!hK:$\b\u0002\u0003':\u0005\u0003\u0005\u000b\u0011B'\u0002#\u001dLGoQ8n[\u0006tGMR1di>\u0014\u0018\u0010\u0005\u0002E\u001d&\u0011q*\u0012\u0002\u0019\u000f&$8i\\7nC:$')^5mI\u0016\u0014h)Y2u_JL\b\u0002C):\u0005\u0003\u0005\u000b\u0011\u0002*\u0002\r\u001dLGoU2n!\t!5+\u0003\u0002U\u000b\n1q)\u001b;TG6D\u0001BV\u001d\u0003\u0002\u0003\u0006IaV\u0001\u000bg\u000el7+\u001a:wS\u000e,\u0007C\u0001-Z\u001b\u00059\u0015B\u0001.H\u0005)\u00196-\\*feZL7-\u001a\u0005\t9f\u0012\t\u0011)A\u0005;\u0006\t\u0002/\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005y\u000bW\"A0\u000b\u0005\u00014\u0011\u0001B;tKJL!AY0\u0003#A+'/\\5tg&|gnU3sm&\u001cW\r\u0003\u0005es\t\u0005\t\u0015!\u0003f\u00039)g/\u001a8u!V\u0014G.[:iKJ\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\u0007\u0005\u0004\u0018N\u0003\u0002k\u0011\u0005)QM^3oi&\u0011An\u001a\u0002\u000f\u000bZ,g\u000e\u001e)vE2L7\u000f[3s\u0011!q\u0017H!A!\u0002\u0013y\u0017aC52q9\u001cVM\u001d<jG\u0016\u0004\"\u0001]:\u000e\u0003ET!A\u001d\u0004\u0002\t%\f\u0004H\\\u0005\u0003iF\u00141\"S\u00199]N+'O^5dK\"Aa/\u000fB\u0001B\u0003%q/\u0001\nqk2d'+Z9vKN$8+\u001a:wS\u000e,\u0007C\u0001=|\u001b\u0005I(B\u0001>\u0007\u0003\u0011\u0001X\u000f\u001c7\n\u0005qL(A\u0005)vY2\u0014V-];fgR\u001cVM\u001d<jG\u0016DQ!G\u001d\u0005\u0002y$\u0012c`A\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011QBA\b!\tq\u0011\bC\u0003C{\u0002\u00071\tC\u0003M{\u0002\u0007Q\nC\u0003R{\u0002\u0007!\u000bC\u0003W{\u0002\u0007q\u000bC\u0003]{\u0002\u0007Q\fC\u0003e{\u0002\u0007Q\rC\u0003o{\u0002\u0007q\u000eC\u0003w{\u0002\u0007q\u000fC\u0004\u0002\u0014e\"\t%!\u0006\u0002\u0019\r\u0014X-\u0019;f\u0005J\fgn\u00195\u0015\u0011\u0005]\u00111EA\u0016\u0003{\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;1\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&!\u0011\u0011EA\u000e\u0005\u0019\u0011%/\u00198dQ\"A\u0011QDA\t\u0001\u0004\t)\u0003\u0005\u0003\u0002\u001a\u0005\u001d\u0012\u0002BA\u0015\u00037\u0011!BU3q_NLGo\u001c:z\u0011!\ti#!\u0005A\u0002\u0005=\u0012A\u00032sC:\u001c\u0007NT1nKB!\u0011\u0011GA\u001c\u001d\r\u0019\u00121G\u0005\u0004\u0003k!\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002:\u0005m\"AB*ue&twMC\u0002\u00026QA\u0001\"a\u0010\u0002\u0012\u0001\u0007\u0011qF\u0001\u000bgR\f'\u000f\u001e)pS:$\b\u0006BA\t\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0006b]:|G/\u0019;j_:T!!!\u0014\u0002\u000b)\fg/\u0019=\n\t\u0005E\u0013q\t\u0002\b\u001d>tg.\u001e7m\u0011\u001d\t)&\u000fC!\u0003/\nA\u0002Z3mKR,'I]1oG\"$\"\"!\u0017\u0002`\u0005\u0005\u00141MA4!\r\u0019\u00121L\u0005\u0004\u0003;\"\"\u0001B+oSRD\u0001\"!\b\u0002T\u0001\u0007\u0011Q\u0005\u0005\t\u0003[\t\u0019\u00061\u0001\u00020!A\u0011QMA*\u0001\u0004\ty#\u0001\u0005f]\u0012\u0004v.\u001b8u\u0011!\tI'a\u0015A\u0002\u0005-\u0014A\u00023ssJ+h\u000eE\u0002\u0014\u0003[J1!a\u001c\u0015\u0005\u001d\u0011un\u001c7fC:Dq!a\u001d:\t\u0013\t)(A\fwC2LG-\u0019;f\u0007\u0006tG)\u001a7fi\u0016\u0014%/\u00198dQRA\u0011\u0011LA<\u0003s\nY\b\u0003\u0005\u0002\u001e\u0005E\u0004\u0019AA\u0013\u0011\u001d\u0019\u0011\u0011\u000fa\u0001\u0003/A\u0001\"!\u001a\u0002r\u0001\u0007\u0011q\u0006\u0005\b\u0003\u007fJD\u0011BAA\u0003Q\t7\r^;bY2LH)\u001a7fi\u0016\u0014%/\u00198dQRA\u0011\u0011LAB\u0003\u000b\u000b9\t\u0003\u0005\u0002\u001e\u0005u\u0004\u0019AA\u0013\u0011\u001d\u0019\u0011Q\u0010a\u0001\u0003/A\u0001\"!\u001a\u0002~\u0001\u0007\u0011q\u0006\u0005\b\u0003\u0017KD\u0011BAG\u00039\u0011'/\u00198dQ\"\u000b7/T8wK\u0012$b!a$\u0002\u0016\u0006]\u0005cA\n\u0002\u0012&\u0019\u00111\u0013\u000b\u0003\u000f9{G\u000f[5oO\"91!!#A\u0002\u0005]\u0001\u0002CAM\u0003\u0013\u0003\r!a\f\u0002\u0017\rD\u0017M\\4fg\u0016$\u0018\n\u001a\u0005\b\u0003;KD\u0011BAP\u0003i1\u0018\r\\5eCR,gj\u001c8CY\u0006t7N\u0011:b]\u000eDg*Y7f)\u0011\tI&!)\t\u0011\u00055\u00121\u0014a\u0001\u0003_Aq!!*:\t\u0013\t9+A\u0011sC&\u001cXM\u0011:b]\u000eD7I]3bi&|gNU3rk\u0016\u001cH/\u001a3Fm\u0016tG\u000f\u0006\u0005\u0002Z\u0005%\u00161VAW\u0011!\ti\"a)A\u0002\u0005\u0015\u0002\u0002CA\u0017\u0003G\u0003\r!a\f\t\u0011\u0005=\u00161\u0015a\u0001\u0003_\t\u0001B\u0019:b]\u000eD\u0017\n\u001a\u0005\b\u0003gKD\u0011BA[\u0003\u0005\u0012\u0018-[:f\u0005J\fgn\u00195EK2,G/[8o%\u0016\fX/Z:uK\u0012,e/\u001a8u)\u0019\tI&a.\u0002:\"A\u0011QDAY\u0001\u0004\t)\u0003C\u0004\u0004\u0003c\u0003\r!a\u0006\t\u000f\u0005u\u0016\b\"\u0003\u0002@\u0006\tb/\u00197jI\u0006$XMU3q_B+'/\\:\u0015\t\u0005e\u0013\u0011\u0019\u0005\t\u0003;\tY\f1\u0001\u0002&!9\u0011QY\u001d\u0005\n\u0005\u001d\u0017!\u0005<bY&$\u0017\r^3Jg\u001eKGOU3q_R!\u0011\u0011LAe\u0011!\ti\"a1A\u0002\u0005\u0015\u0002bBAgs\u0011%\u0011qZ\u0001\u001cm\u0006d\u0017\u000eZ1uK\u001a{'o\u00149f]B+H\u000e\u001c*fcV,7\u000f^:\u0015\r\u0005e\u0013\u0011[Aj\u0011!\ti\"a3A\u0002\u0005\u0015\u0002bB\u0002\u0002L\u0002\u0007\u0011q\u0003\u0005\b\u0003/LD\u0011BAm\u0003MA\u0017m](qK:\u0004V\u000f\u001c7SKF,Xm\u001d;t)\u0019\tY.a:\u0002jR!\u00111NAo\u0011!\ty.!6A\u0002\u0005\u0005\u0018!\u00033je\u0016\u001cG/[8o!\rA\u00181]\u0005\u0004\u0003KL(\u0001\u0006)vY2\u0014V-];fgR$\u0015N]3di&|g\u000e\u0003\u0005\u0002\u001e\u0005U\u0007\u0019AA\u0013\u0011\u001d\u0019\u0011Q\u001ba\u0001\u0003/Aq!!<:\t\u0013\ty/\u0001\fwC2LG-\u0019;f%\u0016\u0004x.S:O_R,U\u000e\u001d;z)\u0011\tI&!=\t\u0011\u0005u\u00111\u001ea\u0001\u0003K\u0001")
public class DefaultBranchService
implements BranchService {
    private final GitAgent gitAgent;
    private final GitCommandBuilderFactory gitCommandFactory;
    private final GitScm gitScm;
    private final ScmService scmService;
    private final PermissionService permissionService;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PullRequestService pullRequestService;

    public static Logger log() {
        return DefaultBranchService$.MODULE$.log();
    }

    public static Integer MAX_BRANCH_SEGMENT_LENGTH() {
        return DefaultBranchService$.MODULE$.MAX_BRANCH_SEGMENT_LENGTH();
    }

    public static Integer MAX_FQ_BRANCH_LENGTH() {
        return DefaultBranchService$.MODULE$.MAX_FQ_BRANCH_LENGTH();
    }

    @Override
    @Nonnull
    public Branch createBranch(Repository repository, String branchName2, String startPoint) {
        this.validateNonBlankBranchName(branchName2);
        this.validateIsGitRepo(repository);
        this.gitScm.validateRefName(branchName2);
        if (StringUtils.isBlank((String)startPoint)) {
            throw new BranchStartPointValidationException(this.i18nService.createKeyedMessage("stash.branch.creation.startpoint.empty", new Object[0]));
        }
        this.validateRepoPerms(repository);
        this.validateRepoIsNotEmpty(repository);
        String branchRef = GitRefPattern.HEADS.qualify(branchName2);
        this.raiseBranchCreationRequestedEvent(repository, branchName2, branchRef);
        try {
            this.gitCommandFactory.builder(repository).branch().create(GitRefPattern.HEADS.unqualify(branchRef)).startPoint(startPoint).build().call();
        }
        catch (CommandFailedException commandFailedException) {
            DefaultBranchService$.MODULE$.log().error("Failed to create branch {} in repository {} / {}", new Object[]{branchName2, repository.getProject().getKey(), repository.getSlug(), commandFailedException});
            throw commandFailedException;
        }
        DefaultBranchService$.MODULE$.log().debug("Created branch {} in repository {} / {}", new Object[]{branchName2, repository.getProject().getKey(), repository.getSlug()});
        Branch branch = this.gitAgent.resolveBranch(repository, branchRef, true);
        if (branch == null) {
            throw new IllegalRepositoryStateException(this.i18nService.createKeyedMessage("stash.branch.creation.branch", new Object[]{branchRef}));
        }
        this.eventPublisher.publish((Object)new BranchCreatedEvent((Object)this, repository, branch));
        return branch;
    }

    @Override
    public void deleteBranch(Repository repository, String branchName2, String endPoint, boolean dryRun) {
        this.validateNonBlankBranchName(branchName2);
        this.validateIsGitRepo(repository);
        Branch branch = this.gitAgent.resolveBranch(repository, branchName2, false);
        if (branch != null) {
            this.validateCanDeleteBranch(repository, branch, endPoint);
            if (!dryRun) {
                this.actuallyDeleteBranch(repository, branch, endPoint);
            }
        }
    }

    private void validateCanDeleteBranch(Repository repository, Branch branch, String endPoint) {
        if (branch.getIsDefault()) {
            throw new UnsupportedOnBranchException(this.i18nService.createKeyedMessage("stash.branch.deletion.default.branch", new Object[]{branch.getDisplayId()}));
        }
        if (endPoint == null || endPoint.equals(branch.getLatestCommit())) {
            this.validateRepoPerms(repository);
            this.validateForOpenPullRequests(repository, branch);
            this.raiseBranchDeletionRequestedEvent(repository, branch);
            return;
        }
        throw this.branchHasMoved(branch, endPoint);
    }

    private void actuallyDeleteBranch(Repository repository, Branch branch, String endPoint) {
        GitUpdateRefDeleteBuilder delete = this.gitCommandFactory.builder(repository).updateRef().delete(branch.getId());
        try {
            (endPoint == null ? delete : delete.oldValue(endPoint)).build().call();
        }
        catch (Throwable throwable) {
            ServerException serverException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ServerException && (serverException = (ServerException)throwable2).getMessage().contains("but expected")) {
                throw this.branchHasMoved(branch, endPoint);
            }
            throw throwable;
        }
        this.eventPublisher.publish((Object)new BranchDeletedEvent((Object)this, repository, branch));
    }

    private Nothing$ branchHasMoved(Branch branch, String changesetId) {
        throw new BranchHasMovedException(this.i18nService.createKeyedMessage("stash.branch.deletion.branch.moved", new Object[0]));
    }

    private void validateNonBlankBranchName(String branchName2) {
        if (StringUtils.isBlank((String)branchName2)) {
            throw new InvalidRefNameException(this.i18nService.createKeyedMessage("stash.branch.creation.name.empty", new Object[0]), "");
        }
    }

    private void raiseBranchCreationRequestedEvent(Repository repository, String branchName2, String branchId) {
        InternalBranch requestedBranch = ((InternalBranch.Builder)new InternalBranch.Builder().id(branchId).displayId(branchName2)).build();
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new BranchCreationRequestedEvent((Object)this, repository, (Branch)requestedBranch, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            throw new BranchCreationCanceledException(this.i18nService.createKeyedMessage("stash.branch.creation.canceled", new Object[]{branchName2}), cancelState.getCancelMessages());
        }
    }

    private void raiseBranchDeletionRequestedEvent(Repository repository, Branch branch) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new BranchDeletionRequestedEvent((Object)this, repository, branch, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            throw new BranchDeletionCanceledException(this.i18nService.createKeyedMessage("stash.branch.deletion.canceled", new Object[]{branch.getDisplayId()}), cancelState.getCancelMessages());
        }
    }

    private void validateRepoPerms(Repository repository) {
        if (this.permissionService.hasRepositoryPermission(repository, Permission.REPO_WRITE)) {
            return;
        }
        throw new ForbiddenException(this.i18nService.createKeyedMessage("stash.branch.creation.lacks.write.perms", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
    }

    private void validateIsGitRepo(Repository repository) {
        String string = repository.getScmId();
        if (!("git" != null ? !"git".equals(string) : string != null)) {
            return;
        }
        throw new IllegalRepositoryStateException(this.i18nService.createKeyedMessage("stash.branch.creation.nongit", new Object[]{repository.getScmId()}));
    }

    private void validateForOpenPullRequests(Repository repository, Branch branch) {
        Serializable hasInDirection = new Serializable(this, repository, branch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultBranchService $outer;
            private final Repository repository$1;
            private final Branch branch$1;

            public final boolean apply(PullRequestDirection direction) {
                return this.$outer.com$atlassian$stash$internal$branch$DefaultBranchService$$hasOpenPullRequests(this.repository$1, this.branch$1, direction);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.repository$1 = repository$1;
                this.branch$1 = branch$1;
            }
        };
        if (BoxesRunTime.unboxToBoolean((Object)hasInDirection.apply((Object)PullRequestDirection.OUTGOING)) || BoxesRunTime.unboxToBoolean((Object)hasInDirection.apply((Object)PullRequestDirection.INCOMING))) {
            throw new UnsupportedOnBranchException(this.i18nService.createKeyedMessage("stash.branch.deletion.open.pull.requests", new Object[0]));
        }
    }

    public boolean com$atlassian$stash$internal$branch$DefaultBranchService$$hasOpenPullRequests(Repository repository, Branch branch, PullRequestDirection direction) {
        Page page = this.pullRequestService.search(new PullRequestSearchRequest.Builder().repositoryAndBranch(direction, repository.getId(), branch.getId()).state(PullRequestState.OPEN).build(), PageUtils.newRequest((int)0, (int)1));
        return page.getSize() > 0;
    }

    private void validateRepoIsNotEmpty(Repository repository) {
        if (this.scmService.isEmpty(repository)) {
            throw new IllegalRepositoryStateException(this.i18nService.createKeyedMessage("stash.branch.creation.empty", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
    }

    public DefaultBranchService(GitAgent gitAgent, GitCommandBuilderFactory gitCommandFactory, GitScm gitScm, ScmService scmService, PermissionService permissionService, EventPublisher eventPublisher, I18nService i18nService, PullRequestService pullRequestService) {
        this.gitAgent = gitAgent;
        this.gitCommandFactory = gitCommandFactory;
        this.gitScm = gitScm;
        this.scmService = scmService;
        this.permissionService = permissionService;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.pullRequestService = pullRequestService;
    }
}

