/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.util.BuilderSupport;
import javax.annotation.Nonnull;

public class FileContext {
    private final String changesetId;
    private final int maxLineLength;
    private final int start;

    private FileContext(Builder builder) {
        this.changesetId = builder.changesetId;
        this.maxLineLength = builder.maxLineLength;
        this.start = builder.start;
    }

    @Nonnull
    public String getChangesetId() {
        return this.changesetId;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public int getStart() {
        return this.start;
    }

    public static class Builder
    extends BuilderSupport {
        private final String changesetId;
        private int maxLineLength;
        private int start;

        public Builder(String changesetId) {
            this.changesetId = Builder.checkNotBlank(changesetId, "changesetId");
        }

        @Nonnull
        public FileContext build() {
            return new FileContext(this);
        }

        @Nonnull
        public Builder maxLineLength(int value) {
            this.maxLineLength = value;
            return this;
        }

        @Nonnull
        public Builder start(int value) {
            this.start = value;
            return this;
        }
    }
}

