/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.avatar;

import com.google.common.base.Preconditions;
import javax.validation.constraints.Min;

public class AvatarRequest {
    private final boolean secure;
    private final int size;
    private final boolean useConfigured;

    public AvatarRequest(boolean secure, @Min(value=1L) int size) {
        this(secure, size, false);
    }

    public AvatarRequest(boolean secure, @Min(value=1L) int size, boolean useConfigured) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        this.secure = secure;
        this.size = size;
        this.useConfigured = useConfigured;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isUseConfigured() {
        return this.useConfigured;
    }
}

