/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.repository;

import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.RefChangeType;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class SimpleRefChange
implements RefChange {
    private final String refId;
    private final String fromHash;
    private final String toHash;
    private final RefChangeType type;

    protected SimpleRefChange(@Nonnull String refId, @Nonnull String fromHash, @Nonnull String toHash, @Nonnull RefChangeType type) {
        this.fromHash = fromHash;
        this.refId = refId;
        this.toHash = toHash;
        this.type = type;
    }

    @Override
    @Nonnull
    public String getFromHash() {
        return this.fromHash;
    }

    @Override
    @Nonnull
    public String getRefId() {
        return this.refId;
    }

    @Override
    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    @Override
    @Nonnull
    public RefChangeType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleRefChange) {
            SimpleRefChange that = (SimpleRefChange)o;
            return this.fromHash.equals(that.fromHash) && this.refId.equals(that.refId) && this.toHash.equals(that.toHash) && this.type.equals((Object)that.type);
        }
        return false;
    }

    public int hashCode() {
        int result = this.refId.hashCode();
        result = 31 * result + this.fromHash.hashCode();
        result = 31 * result + this.toHash.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public static class Builder {
        private String fromHash;
        private String refId;
        private String toHash;
        private RefChangeType type;

        public Builder() {
        }

        public Builder(@Nonnull RefChange change) {
            this.fromHash = ((RefChange)Preconditions.checkNotNull((Object)change, (Object)"change")).getFromHash();
            this.refId = change.getRefId();
            this.toHash = change.getToHash();
            this.type = change.getType();
        }

        @Nonnull
        public SimpleRefChange build() {
            Preconditions.checkNotNull((Object)this.fromHash, (Object)"fromHash");
            Preconditions.checkNotNull((Object)this.refId, (Object)"refId");
            Preconditions.checkNotNull((Object)this.toHash, (Object)"toHash");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"type");
            return new SimpleRefChange(this.refId, this.fromHash, this.toHash, this.type);
        }

        @Nonnull
        public Builder from(@Nonnull Ref ref) {
            this.refId = ((Ref)Preconditions.checkNotNull((Object)ref, (Object)"ref")).getId();
            this.fromHash = ref.getLatestCommit();
            return this;
        }

        @Nonnull
        public Builder fromHash(@Nonnull String value) {
            this.fromHash = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        @Nonnull
        public Builder refId(@Nonnull String value) {
            this.refId = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        @Nonnull
        public Builder to(@Nonnull Ref ref) {
            this.refId = ((Ref)Preconditions.checkNotNull((Object)ref, (Object)"ref")).getId();
            this.toHash = ref.getLatestCommit();
            return this;
        }

        @Nonnull
        public Builder toHash(@Nonnull String value) {
            this.toHash = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        @Nonnull
        public Builder type(@Nonnull RefChangeType value) {
            this.type = (RefChangeType)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"value"));
            return this;
        }
    }
}

