/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.pull;

import com.atlassian.stash.pull.AbstractPullRequestRequest;
import com.atlassian.stash.pull.PullRequest;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestTaskSearchRequest
extends AbstractPullRequestRequest {
    private final Set<Long> anchorIds;
    private final PullRequest pullRequest;

    private PullRequestTaskSearchRequest(Builder builder) {
        super(builder);
        this.anchorIds = builder.anchorIds.build();
        this.pullRequest = builder.pullRequest;
    }

    @Nonnull
    public Set<Long> getAnchorIds() {
        return this.anchorIds;
    }

    @Nullable
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    public boolean hasPullRequest() {
        return this.pullRequest != null;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private final ImmutableSet.Builder<Long> anchorIds = ImmutableSet.builder();
        private PullRequest pullRequest;

        public Builder(@Nonnull PullRequest pullRequest) {
            super(pullRequest);
            this.pullRequest = pullRequest;
        }

        public Builder(int repositoryId, long pullRequestId) {
            super(repositoryId, pullRequestId);
        }

        @Nonnull
        public Builder anchor(long value) {
            this.anchorIds.add((Object)value);
            return this.self();
        }

        @Nonnull
        public Builder anchors(@Nullable Iterable<Long> value) {
            Builder.addIf(Predicates.notNull(), this.anchorIds, value);
            return this.self();
        }

        @Nonnull
        public PullRequestTaskSearchRequest build() {
            return new PullRequestTaskSearchRequest(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

