/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.util.BuilderSupport;
import javax.annotation.Nonnull;

public class FileContext {
    private final String commitId;
    private final int maxLineLength;
    private final int start;

    private FileContext(Builder builder) {
        this.commitId = builder.commitId;
        this.maxLineLength = builder.maxLineLength;
        this.start = builder.start;
    }

    @Deprecated
    @Nonnull
    public String getChangesetId() {
        return this.commitId;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public int getStart() {
        return this.start;
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private int maxLineLength;
        private int start;

        public Builder(@Nonnull String commitId) {
            this.commitId = Builder.checkNotBlank(commitId, "commitId");
        }

        @Nonnull
        public FileContext build() {
            return new FileContext(this);
        }

        @Nonnull
        public Builder maxLineLength(int value) {
            this.maxLineLength = value;
            return this;
        }

        @Nonnull
        public Builder start(int value) {
            this.start = value;
            return this;
        }
    }
}

