/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.concurrent;

import com.atlassian.stash.concurrent.BucketProcessor;
import com.atlassian.stash.concurrent.ConcurrencyPolicy;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class BucketedExecutorSettings<T extends Serializable> {
    private final int batchSize;
    private final Function<T, String> bucketIdExtractor;
    private final ConcurrencyPolicy concurrencyPolicy;
    private final int maxAttempts;
    private final int maxConcurrency;
    private final BucketProcessor<T> processor;

    private BucketedExecutorSettings(Builder<T> builder) {
        this.batchSize = ((Builder)builder).batchSize;
        this.bucketIdExtractor = ((Builder)builder).bucketIdExtractor;
        this.concurrencyPolicy = ((Builder)builder).concurrencyPolicy;
        this.maxAttempts = ((Builder)builder).maxAttempts;
        this.maxConcurrency = builder.maxConcurrency;
        this.processor = ((Builder)builder).processor;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @Nonnull
    public Function<T, String> getBucketIdExtractor() {
        return this.bucketIdExtractor;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    @Nonnull
    public ConcurrencyPolicy getMaxConcurrencyPolicy() {
        return this.concurrencyPolicy;
    }

    @Nonnull
    public BucketProcessor<T> getProcessor() {
        return this.processor;
    }

    public static class Builder<T extends Serializable> {
        private final Function<T, String> bucketIdExtractor;
        private final BucketProcessor<T> processor;
        private int batchSize;
        private ConcurrencyPolicy concurrencyPolicy;
        private int maxAttempts;
        public int maxConcurrency;

        public Builder(@Nonnull Function<T, String> bucketIdExtractor, @Nonnull BucketProcessor<T> processor) {
            this.bucketIdExtractor = (Function)Preconditions.checkNotNull(bucketIdExtractor, (Object)"bucketIdExtractor");
            this.processor = (BucketProcessor)Preconditions.checkNotNull(processor, (Object)"processor");
            this.batchSize = Integer.MAX_VALUE;
            this.maxAttempts = 2;
            this.concurrencyPolicy = ConcurrencyPolicy.PER_NODE;
            this.maxConcurrency = 2;
        }

        public Builder<T> batchSize(int value) {
            this.batchSize = value;
            return this;
        }

        public BucketedExecutorSettings<T> build() {
            return new BucketedExecutorSettings(this);
        }

        public Builder<T> maxAttempts(int value) {
            this.maxAttempts = value;
            return this;
        }

        public Builder<T> maxConcurrency(int value, ConcurrencyPolicy policy) {
            this.concurrencyPolicy = policy;
            this.maxConcurrency = value;
            return this;
        }
    }
}

