/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.commit;

import com.atlassian.stash.commit.MinimalCommit;
import com.atlassian.stash.util.BuilderSupport;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SimpleMinimalCommit
implements MinimalCommit,
Serializable {
    public static final int DEFAULT_DISPLAY_ID_LENGTH = 11;
    private final String displayId;
    private final String id;

    protected SimpleMinimalCommit(AbstractMinimalCommitBuilder<?, ?> builder) {
        this.id = builder.id;
        this.displayId = ((AbstractMinimalCommitBuilder)builder).getDisplayId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleMinimalCommit) {
            SimpleMinimalCommit that = (SimpleMinimalCommit)o;
            return Objects.equal((Object)this.getId(), (Object)that.getId());
        }
        return false;
    }

    @Override
    @Nonnull
    public String getDisplayId() {
        return this.displayId;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId()});
    }

    public String toString() {
        return "SimpleMinimalCommit(id='" + this.getId() + "')";
    }

    protected static abstract class AbstractMinimalCommitBuilder<B extends AbstractMinimalCommitBuilder<B, R>, R extends MinimalCommit>
    extends BuilderSupport {
        protected final String id;
        protected String displayId;

        protected AbstractMinimalCommitBuilder(@Nonnull String id) {
            this.id = AbstractMinimalCommitBuilder.checkNotBlank(id, "id");
        }

        protected AbstractMinimalCommitBuilder(@Nonnull R commit) {
            this.displayId = ((MinimalCommit)Preconditions.checkNotNull(commit, (Object)"ref")).getDisplayId();
            this.id = commit.getId();
        }

        @Nonnull
        public abstract R build();

        @Nonnull
        public B displayId(@Nullable String value) {
            this.displayId = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();

        @Nonnull
        private String getDisplayId() {
            return this.displayId == null ? StringUtils.substring((String)this.id, (int)0, (int)11) : this.displayId;
        }
    }

    public static class Builder
    extends AbstractMinimalCommitBuilder<Builder, MinimalCommit> {
        public Builder(@Nonnull String id) {
            super(id);
        }

        public Builder(@Nonnull MinimalCommit commit) {
            super(commit);
        }

        @Override
        @Nonnull
        public SimpleMinimalCommit build() {
            return new SimpleMinimalCommit(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

