/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.atlassian.stash.util.PageRequest;
import javax.annotation.Nullable;

public class PageRequestImpl
implements PageRequest {
    private final int start;
    private final int limit;
    private final String filter;

    public PageRequestImpl(int start, int limit) {
        this(start, limit, null);
    }

    public PageRequestImpl(int start, int limit, @Nullable String filter) {
        this.start = start < 0 ? 0 : start;
        this.limit = limit <= 0 ? 1 : limit;
        this.filter = filter;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    @Nullable
    public String getFilter() {
        return this.filter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.limit;
        result = 31 * result + this.start;
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageRequestImpl other = (PageRequestImpl)obj;
        if (this.limit != other.limit) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return !(this.filter != null ? !this.filter.equals(other.filter) : other.filter != null);
    }

    @Override
    public PageRequest buildRestrictedPageRequest(int maxLimit) {
        return new PageRequestImpl(this.start, Math.min(this.limit, maxLimit), this.filter);
    }
}

