/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.user;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public final class CaptchaResponse {
    private final String challengeId;
    private final String userResponse;

    public CaptchaResponse(String challengeId, String userResponse) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)challengeId), (Object)"Challenge id must be provided");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)userResponse), (Object)"User response must be provided");
        this.challengeId = challengeId;
        this.userResponse = userResponse;
    }

    public String getChallengeId() {
        return this.challengeId;
    }

    public String getUserResponse() {
        return this.userResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaptchaResponse that = (CaptchaResponse)o;
        if (!this.challengeId.equals(that.challengeId)) {
            return false;
        }
        return this.userResponse.equals(that.userResponse);
    }

    public int hashCode() {
        int result = this.challengeId.hashCode();
        result = 31 * result + this.userResponse.hashCode();
        return result;
    }

    public String toString() {
        return "CaptchaResponse{challengeId='" + this.challengeId + '\'' + ", userResponse='" + this.userResponse + '\'' + '}';
    }
}

