/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.validation;

import com.atlassian.stash.validation.URI;
import java.net.URISyntaxException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class URIValidator
implements ConstraintValidator<URI, String> {
    private String[] schemes;

    public void initialize(URI uri) {
        this.schemes = uri.schemes();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        java.net.URI uri;
        if (value == null || value.length() == 0) {
            return true;
        }
        try {
            uri = new java.net.URI(value);
        }
        catch (URISyntaxException e) {
            return false;
        }
        if (this.schemes.length == 0) {
            return true;
        }
        String uriScheme = uri.getScheme();
        for (String scheme : this.schemes) {
            if (!scheme.equalsIgnoreCase(uriScheme)) continue;
            return true;
        }
        return false;
    }
}

