/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.user;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum Permission {
    REPO_READ(0, false, new Permission[0]),
    REPO_WRITE(1, false, REPO_READ),
    REPO_ADMIN(8, false, REPO_READ, REPO_WRITE),
    PROJECT_READ(2, false, REPO_READ),
    PROJECT_WRITE(3, false, PROJECT_READ, REPO_WRITE),
    PROJECT_ADMIN(4, false, PROJECT_WRITE, REPO_ADMIN),
    LICENSED_USER(9, true, new Permission[0]),
    PROJECT_CREATE(5, true, LICENSED_USER),
    ADMIN(6, true, PROJECT_CREATE, PROJECT_ADMIN),
    SYS_ADMIN(7, true, ADMIN);

    private static Map<Integer, Permission> idMap;
    private final int id;
    private final boolean global;
    private final Set<Permission> inheritedPermissions;
    private Set<Permission> inheritingPermissions;
    private Set<Permission> higherPermissions;

    private Permission(int id, boolean global, Permission ... inherited) {
        this.id = id;
        this.global = global;
        HashSet<Permission> perms = new HashSet<Permission>();
        for (Permission p : inherited) {
            this.collectInheritedPermissions(perms, p);
        }
        this.inheritedPermissions = Collections.unmodifiableSet(perms);
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isGrantableToAnonymous() {
        return false;
    }

    public boolean isGrantableToAll() {
        return this != SYS_ADMIN && this != ADMIN;
    }

    public int getId() {
        return this.id;
    }

    public static Permission fromId(int id) {
        if (idMap == null) {
            idMap = new HashMap<Integer, Permission>();
            for (Permission permission : Permission.values()) {
                idMap.put(permission.getId(), permission);
            }
        }
        return idMap.get(id);
    }

    public Set<Permission> getInheritedPermissions() {
        return this.inheritedPermissions;
    }

    public Set<Permission> getInheritingPermissions() {
        if (this.inheritingPermissions == null) {
            EnumSet<Permission> perms = EnumSet.of(this);
            for (Permission p : Permission.values()) {
                if (!p.getInheritedPermissions().contains((Object)this)) continue;
                perms.add(p);
            }
            this.inheritingPermissions = Collections.unmodifiableSet(perms);
        }
        return this.inheritingPermissions;
    }

    public Set<Permission> getImplyingPermissions() {
        if (this.higherPermissions == null) {
            HashSet<Permission> inheriting = new HashSet<Permission>();
            inheriting.addAll(this.getInheritingPermissions());
            inheriting.remove((Object)this);
            this.higherPermissions = Collections.unmodifiableSet(inheriting);
        }
        return this.higherPermissions;
    }

    private void collectInheritedPermissions(Set<Permission> perms, Permission p) {
        perms.add(p);
        for (Permission perm : p.getInheritedPermissions()) {
            this.collectInheritedPermissions(perms, perm);
        }
    }

    public static Iterable<Permission> getGlobalPermissions() {
        return Iterables.filter(Arrays.asList(Permission.values()), (Predicate)new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return permission.isGlobal();
            }
        });
    }
}

