/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.repository;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class Version
implements Comparable<Version> {
    private static final Pattern STARTS_NUMERICAL_PATTERN = Pattern.compile("^(\\d+).*");
    private final List<Integer> version;
    private final String versionString;

    public Version(Integer ... elements) {
        this.version = this.normalise(Lists.newArrayList((Object[])elements));
        this.versionString = StringUtils.join(this.version, (String)".");
    }

    public Version(String version) {
        String[] components = version.split("[\\.\\-]");
        ArrayList list = Lists.newArrayListWithCapacity((int)components.length);
        for (String component : components) {
            try {
                list.add(Integer.valueOf(component));
            }
            catch (NumberFormatException e) {
                Matcher matcher = STARTS_NUMERICAL_PATTERN.matcher(component);
                if (!matcher.matches()) break;
                list.add(Integer.valueOf(matcher.group(1)));
                break;
            }
        }
        this.version = this.normalise(list);
        this.versionString = StringUtils.join(this.version, (String)".");
    }

    @Override
    public int compareTo(Version o) {
        int mySize = this.version.size();
        int theirSize = o.version.size();
        int maxSize = Math.max(theirSize, mySize);
        for (int i = 0; i < maxSize; ++i) {
            int theirs;
            int mine = i < mySize ? this.version.get(i) : 0;
            int diff = mine - (theirs = i < theirSize ? o.version.get(i) : 0);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return this.versionString.equals(other.versionString);
    }

    public List<Integer> getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.versionString.hashCode();
    }

    public String toString() {
        return this.versionString;
    }

    private List<Integer> normalise(List<Integer> list) {
        while (list.size() < 3) {
            list.add(0);
        }
        return ImmutableList.copyOf(list);
    }
}

