/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.plugin.remote.event.listener;

import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.plugin.remote.event.listener.AbstractEventProducer;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.util.NamedLink;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.RemoteEventProducerRegistrar;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.stash.plugin.remote.event.StashRepositoryRefsChangedEvent;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@AsynchronousPreferred
public class BitbucketRepositoryRefsChangedEventProducer
extends AbstractEventProducer {
    private static final Logger log = LoggerFactory.getLogger(BitbucketRepositoryRefsChangedEventProducer.class);
    private final RepositoryService repositoryService;

    @Inject
    public BitbucketRepositoryRefsChangedEventProducer(@ComponentImport EventPublisher eventPublisher, @ComponentImport RemoteEventProducerRegistrar remoteEventProducerRegistrar, @ComponentImport RepositoryService repositoryService) {
        super(eventPublisher, remoteEventProducerRegistrar);
        this.repositoryService = repositoryService;
    }

    public Iterable<Class<? extends RemoteEvent>> produces() {
        return ImmutableSet.of(StashRepositoryRefsChangedEvent.class);
    }

    @EventListener
    public void handleRepositoryRefsChanged(RepositoryRefsChangedEvent event) {
        Repository repository = event.getRepository();
        String projectKey = repository.getProject().getKey();
        String repositorySlug = repository.getSlug();
        String committer = event.getUser() != null ? event.getUser().getSlug() : null;
        Set cloneLinks = this.repositoryService.getCloneLinks(new RepositoryCloneLinksRequest.Builder().repository(event.getRepository()).build());
        log.trace("handleRepositoryRefsChanged() projectKey={}; repositorySlug={}; committer={}, #refChanges={}, cloneLinks={};", new Object[]{projectKey, repositorySlug, committer, event.getRefChanges().size(), cloneLinks});
        if (!event.getRefChanges().isEmpty()) {
            this.eventPublisher.publish((Object)new StashRepositoryRefsChangedEvent(projectKey, repositorySlug, committer, (Set<StashRepositoryRefsChangedEvent.CloneLink>)ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)((Iterable)MoreObjects.firstNonNull((Object)cloneLinks, Collections.emptySet())), (Function)new Function<NamedLink, StashRepositoryRefsChangedEvent.CloneLink>(){

                public StashRepositoryRefsChangedEvent.CloneLink apply(NamedLink namedLink) {
                    return new StashRepositoryRefsChangedEvent.CloneLink(namedLink.getName(), namedLink.getHref());
                }
            }))));
        }
    }
}

