/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.plugin.remote.event.listener;

import com.atlassian.bitbucket.event.pull.PullRequestDeclinedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReopenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.plugin.remote.event.listener.AbstractEventProducer;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.RemoteEventProducerRegistrar;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.stash.plugin.remote.event.AbstractStashPullRequestRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashPullRequestDeclinedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashPullRequestMergedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashPullRequestOpenedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashPullRequestReopenedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashPullRequestUpdatedRemoteEvent;
import com.google.common.collect.ImmutableSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class BitbucketPullRequestEventProducer
extends AbstractEventProducer {
    private static final Logger log = LoggerFactory.getLogger(BitbucketPullRequestEventProducer.class);

    @Inject
    public BitbucketPullRequestEventProducer(@ComponentImport EventPublisher eventPublisher, @ComponentImport RemoteEventProducerRegistrar remoteEventProducerRegistrar) {
        super(eventPublisher, remoteEventProducerRegistrar);
    }

    public Iterable<Class<? extends RemoteEvent>> produces() {
        return ImmutableSet.of(StashPullRequestOpenedRemoteEvent.class, StashPullRequestMergedRemoteEvent.class, StashPullRequestReopenedRemoteEvent.class, StashPullRequestDeclinedRemoteEvent.class, StashPullRequestUpdatedRemoteEvent.class);
    }

    @EventListener
    public void handlePullRequestOpenedEvent(PullRequestOpenedEvent pullRequestOpenedEvent) {
        StashPullRequestOpenedRemoteEvent.Builder builder = new StashPullRequestOpenedRemoteEvent.Builder();
        this.populateAndPublish(builder, (PullRequestEvent)pullRequestOpenedEvent);
    }

    @EventListener
    public void handlePullRequestMergedEvent(PullRequestMergedEvent pullRequestMergedEvent) {
        StashPullRequestMergedRemoteEvent.Builder builder = new StashPullRequestMergedRemoteEvent.Builder();
        this.populateAndPublish(builder, (PullRequestEvent)pullRequestMergedEvent);
    }

    @EventListener
    public void handlePullRequestReopenedEvent(PullRequestReopenedEvent pullRequestReopenedEvent) {
        StashPullRequestReopenedRemoteEvent.Builder builder = new StashPullRequestReopenedRemoteEvent.Builder();
        this.populateAndPublish(builder, (PullRequestEvent)pullRequestReopenedEvent);
    }

    @EventListener
    public void handlePullRequestDeclinedEvent(PullRequestDeclinedEvent pullRequestDeclinedEvent) {
        StashPullRequestDeclinedRemoteEvent.Builder builder = new StashPullRequestDeclinedRemoteEvent.Builder();
        this.populateAndPublish(builder, (PullRequestEvent)pullRequestDeclinedEvent);
    }

    @EventListener
    public void handlePullRequestUpdatedEvent(PullRequestUpdatedEvent pullRequestUpdatedEvent) {
        StashPullRequestUpdatedRemoteEvent.Builder builder = new StashPullRequestUpdatedRemoteEvent.Builder();
        this.populateAndPublish(builder, (PullRequestEvent)pullRequestUpdatedEvent);
    }

    private void populateAndPublish(AbstractStashPullRequestRemoteEvent.AbstractBuilder<?, ?> builder, PullRequestEvent pullRequestEvent) {
        PullRequest pullRequest = pullRequestEvent.getPullRequest();
        Repository fromRepository = pullRequest.getFromRef().getRepository();
        Repository toRepository = pullRequest.getToRef().getRepository();
        ((AbstractStashPullRequestRemoteEvent.AbstractBuilder)((AbstractStashPullRequestRemoteEvent.AbstractBuilder)((AbstractStashPullRequestRemoteEvent.AbstractBuilder)((AbstractStashPullRequestRemoteEvent.AbstractBuilder)((AbstractStashPullRequestRemoteEvent.AbstractBuilder)((AbstractStashPullRequestRemoteEvent.AbstractBuilder)builder.id(pullRequest.getId())).fromProjectKey(fromRepository.getProject().getKey())).fromRepositorySlug(fromRepository.getSlug())).fromBranch(pullRequest.getFromRef().getId())).toProjectKey(toRepository.getProject().getKey())).toRepositorySlug(toRepository.getSlug())).toBranch(pullRequest.getToRef().getId());
        this.eventPublisher.publish(builder.build());
    }
}

