/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.plugin.remote.event.listener;

import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.plugin.remote.event.listener.AbstractEventProducer;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.RemoteEventProducerRegistrar;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.stash.plugin.remote.event.StashBranchChangedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashBranchCreatedRemoteEvent;
import com.atlassian.stash.plugin.remote.event.StashBranchDeletedRemoteEvent;
import com.google.common.collect.ImmutableSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@AsynchronousPreferred
public class BitbucketBranchChangedEventProducer
extends AbstractEventProducer {
    private static final Logger log = LoggerFactory.getLogger(BitbucketBranchChangedEventProducer.class);
    private static final String REFS_HEADS = "refs/heads/";

    @Inject
    public BitbucketBranchChangedEventProducer(@ComponentImport EventPublisher eventPublisher, @ComponentImport RemoteEventProducerRegistrar remoteEventProducerRegistrar) {
        super(eventPublisher, remoteEventProducerRegistrar);
    }

    public Iterable<Class<? extends RemoteEvent>> produces() {
        return ImmutableSet.of(StashBranchChangedRemoteEvent.class, StashBranchCreatedRemoteEvent.class, StashBranchDeletedRemoteEvent.class);
    }

    @EventListener
    public void handleRepositoryRefsChanged(RepositoryRefsChangedEvent event) {
        Repository repository = event.getRepository();
        String projectKey = repository.getProject().getKey();
        String repositorySlug = repository.getSlug();
        String committer = event.getUser() != null ? event.getUser().getSlug() : null;
        for (RefChange refChange : event.getRefChanges()) {
            if (!refChange.getRefId().startsWith(REFS_HEADS)) continue;
            String branch = refChange.getRefId().replace(REFS_HEADS, "");
            log.trace("handleRepositoryRefsChanged() projectKey={}; repositorySlug={}; type={}; branch={}; committer={};", new Object[]{projectKey, repositorySlug, refChange.getType(), branch, committer});
            switch (refChange.getType()) {
                case ADD: {
                    this.eventPublisher.publish((Object)new StashBranchCreatedRemoteEvent(projectKey, repositorySlug, branch, committer));
                    break;
                }
                case DELETE: {
                    this.eventPublisher.publish((Object)new StashBranchDeletedRemoteEvent(projectKey, repositorySlug, branch, committer));
                    break;
                }
                case UPDATE: {
                    this.eventPublisher.publish((Object)new StashBranchChangedRemoteEvent(projectKey, repositorySlug, branch, committer));
                }
            }
        }
    }
}

