package com.atlassian.soy.renderer;

/**
 * The type of sanitization previously applied to a {@link SanitizedString string}
 *
 * @since 2.6
 */
public enum SanitizationType {
    /**
     * A value which can safely be included in a JavaScript string without causing a syntax error or
     * an XSS vulnerability
     */
    JAVASCRIPT,
    /**
     * A value which can safely be included in a HTML document without causing a syntax error or
     * an XSS vulnerability
     */
    HTML,
    /**
     * A value which can safely be included in a HTML tag attribute without causing a syntax error or
     * an XSS vulnerability
     */
    HTML_ATTRIBUTE,
    /**
     * A value which can safely be included in a URI without causing the URI to be malformed
     */
    URI
}
