/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.renderer;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SoyResourceModuleDescriptor
extends WebResourceModuleDescriptor {
    private static final Logger log = LoggerFactory.getLogger(SoyResourceModuleDescriptor.class);
    public static final String XML_ELEMENT_NAME = "soy-resource";
    private Iterable<String> functionNames = Collections.emptyList();
    private Iterable<String> nativeFunctionNames = Collections.emptyList();
    private Iterable<Class<? extends SoyServerFunction<?>>> functions = Collections.emptyList();
    private Iterable<Class<?>> nativeFunctions = Collections.emptyList();
    private HostContainer hostContainer;

    public SoyResourceModuleDescriptor(ModuleFactory moduleFactory, HostContainer hostContainer) {
        super(moduleFactory, hostContainer);
        this.hostContainer = hostContainer;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.functionNames = Collections.unmodifiableList(this.getContentsOfChildElements(element, "function"));
        this.nativeFunctionNames = Collections.unmodifiableList(this.getContentsOfChildElements(element, "soy-function"));
    }

    public void enabled() {
        super.enabled();
        ArrayList funcs = Lists.newArrayList();
        for (String functionName : this.functionNames) {
            funcs.add(this.loadFunctionClass(this.getPlugin(), functionName));
        }
        this.functions = funcs;
        ArrayList nativeFuncs = Lists.newArrayList();
        for (String nativeFunctionName : this.nativeFunctionNames) {
            nativeFuncs.add(this.loadClassByName(this.getPlugin(), nativeFunctionName));
        }
        this.nativeFunctions = nativeFuncs;
        log.warn("soy-resource is deprecated. Please convert {} to a web-resource and/or a soy-function", (Object)this.getCompleteKey());
    }

    private Class<? extends SoyServerFunction<?>> loadFunctionClass(Plugin plugin, String functionClass) {
        Class<?> clazz = this.loadClassByName(plugin, functionClass);
        if (!SoyServerFunction.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Class " + functionClass + " does not implement " + SoyServerFunction.class.getName());
        }
        return clazz;
    }

    private Class<?> loadClassByName(Plugin plugin, String className) {
        Class clazz;
        try {
            clazz = plugin.loadClass(className, SoyResourceModuleDescriptor.class);
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = ClassLoaderUtils.loadClass((String)className, SoyResourceModuleDescriptor.class);
            }
            catch (ClassNotFoundException e1) {
                throw new IllegalStateException("Failed to load class '" + className + "' for plugin " + plugin.getName(), e);
            }
        }
        return clazz;
    }

    public Iterable<SoyServerFunction> getFunctions() {
        return Iterables.transform(this.functions, (Function)new Function<Class<? extends SoyServerFunction>, SoyServerFunction>(){

            public SoyServerFunction apply(Class<? extends SoyServerFunction> functionClass) {
                return (SoyServerFunction)SoyResourceModuleDescriptor.this.createBean(functionClass);
            }
        });
    }

    public Iterable<Object> getNativeFunctions() {
        return Iterables.transform(this.nativeFunctions, (Function)new Function<Class<?>, Object>(){

            public Object apply(Class<?> functionClass) {
                return SoyResourceModuleDescriptor.this.createBean(functionClass);
            }
        });
    }

    private <T> T createBean(Class<? extends T> klass) {
        if (this.getPlugin() instanceof ContainerManagedPlugin) {
            return (T)((ContainerManagedPlugin)this.getPlugin()).getContainerAccessor().createBean(klass);
        }
        return (T)this.hostContainer.create(klass);
    }

    private List<String> getContentsOfChildElements(Element element, String elementName) {
        ArrayList strings = Lists.newArrayList();
        for (Element e : element.elements(elementName)) {
            strings.add(e.getTextTrim());
        }
        return strings;
    }
}

