/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.impl.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import java.util.Deque;
import java.util.Map;

class GuiceStackingScope
extends GuiceSimpleScope {
    private final ThreadLocal<Deque<Map<Key<?>, Object>>> stackedThreadLocal = new ThreadLocal();

    GuiceStackingScope() {
    }

    public void enter() {
        if (!this.isActive()) {
            this.stackedThreadLocal.set(Lists.newLinkedList());
        }
        this.stackedThreadLocal.get().push(Maps.newHashMap());
    }

    public void exit() {
        this.stackedThreadLocal.get().pop();
        if (!this.isActive()) {
            this.stackedThreadLocal.remove();
        }
    }

    public boolean isActive() {
        Deque<Map<Key<?>, Object>> stack = this.stackedThreadLocal.get();
        return stack != null && !stack.isEmpty();
    }

    public <T> void seed(Key<T> key, T value) {
        Map<Key<?>, Object> scopedObjects = this.getScopedValues(key);
        Preconditions.checkState((!scopedObjects.containsKey(key) ? 1 : 0) != 0, (String)"A value for the key %s was already seeded in this scope. Old value: %s New value: %s", (Object[])new Object[]{key, scopedObjects.get(key), value});
        scopedObjects.put(key, value);
    }

    public <T> T getForTesting(Key<T> key) {
        Map<Key<?>, Object> scopedValues = this.getScopedValues(key);
        Object value = scopedValues.get(key);
        if (value == null && !scopedValues.containsKey(key)) {
            throw new IllegalStateException("The key " + key + " has not been seeded in this scope");
        }
        return (T)value;
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscopedProvider) {
        return new Provider<T>(){

            public T get() {
                Map<Key<?>, Object> scopedValues = GuiceStackingScope.this.getScopedValues(key);
                Object value = scopedValues.get(key);
                if (value == null && !scopedValues.containsKey(key)) {
                    value = unscopedProvider.get();
                    scopedValues.put(key, value);
                }
                return value;
            }
        };
    }

    protected <T> Map<Key<?>, Object> getScopedValues(Key<T> key) {
        if (!this.isActive()) {
            throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
        }
        return this.stackedThreadLocal.get().peek();
    }
}

