/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.impl.functions;

import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.inject.Singleton;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.tofu.restricted.SoyTofuFunction;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

@Singleton
public class RequireResourcesForContextFunction
implements SoyTofuFunction {
    private static final Set<Integer> ARGS_SIZE = Collections.singleton(1);
    private final WebResourceManager webResourceManager;

    @Inject
    public RequireResourcesForContextFunction(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    public SoyData computeForTofu(List<SoyData> args) {
        SoyData data = args.get(0);
        if (!(data instanceof StringData)) {
            throw new SoySyntaxException("Argument to " + this.getName() + "() is not a literal string");
        }
        String context = data.stringValue();
        this.webResourceManager.requireResourcesForContext(context);
        return StringData.EMPTY_STRING;
    }

    public String getName() {
        return "webResourceManager_requireResourcesForContext";
    }

    public Set<Integer> getValidArgsSizes() {
        return ARGS_SIZE;
    }
}

