/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.impl;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import com.atlassian.soy.impl.DevMode;
import com.atlassian.soy.impl.QuieterSoySyntaxException;
import com.atlassian.soy.impl.SoyManager;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import java.util.List;
import org.dom4j.Element;

public class SoyTransformer
implements WebResourceTransformer {
    private final SoyManager soyManager;

    public SoyTransformer(SoyManager soyManager) {
        this.soyManager = soyManager;
    }

    public DownloadableResource transform(Element element, ResourceLocation location, String filePath, DownloadableResource nextResource) {
        return new SoyResource(nextResource, location.getLocation());
    }

    private class SoyResource
    extends CharSequenceDownloadableResource {
        private final String location;
        private final SoyJsSrcOptions jsSrcOptions;

        private SoyResource(DownloadableResource originalResource, String location) {
            super(originalResource);
            this.location = location;
            this.jsSrcOptions = new SoyJsSrcOptions();
            this.jsSrcOptions.setShouldGenerateJsdoc(false);
        }

        public String getContentType() {
            return "text/javascript";
        }

        protected CharSequence transform(CharSequence originalContent) {
            try {
                SoyFileSet.Builder sfsBuilder = SoyTransformer.this.soyManager.makeSoyFileSetBuilder();
                sfsBuilder.add(originalContent, this.location);
                SoyFileSet sfs = sfsBuilder.build();
                List output = sfs.compileToJsSrc(this.jsSrcOptions, null);
                if (output.size() != 1) {
                    throw new IllegalStateException("Did not manage to compile soy template at:" + this.location + ", size=" + output.size());
                }
                return (CharSequence)output.get(0);
            }
            catch (SoySyntaxException e) {
                if (DevMode.isDevMode()) {
                    throw new QuieterSoySyntaxException(e.getMessage());
                }
                throw e;
            }
        }
    }
}

