package com.atlassian.seraph.cookie;

/**
 * Encodes and decodes the username and password for remember-me cookies
 *
 * @deprecated replaced by the {@link com.atlassian.seraph.service.rememberme.RememberMeService} code
 */
public interface CookieEncoder
{
    /**
     * Builds a cookie string containing a username and password, using offsets to customise the encoding.
     * <p>
     * 
     * @param username
     *            The username.
     * @param password
     *            The password.
     * @param encoding
     *            A String used to customise cookie encoding (only the first 3 characters are used)
     * @return String encoding the input parameters, an empty string if one of the arguments equals <code>null</code>.
     */
    public String encodePasswordCookie(String username, String password, String encoding);

    /**
     * Decodes a cookie string containing a username and password.
     * 
     * @param cookieVal
     *            The cookie value.
     * @param encoding
     *            A String used to customise cookie encoding (only the first 3 characters are used) - should be the same string you used to encode the
     *            cookie!
     * @return String[] containing the username at index 0 and the password at index 1, or <code>{ null, null }</code> if cookieVal equals
     *         <code>null</code> or the empty string.
     */
    public String[] decodePasswordCookie(String cookieVal, String encoding);
}
