package com.atlassian.seraph.util;

import com.atlassian.seraph.cookie.CookieEncoder;
import com.atlassian.seraph.cookie.CookieFactory;
import com.atlassian.seraph.cookie.InsecureCookieEncoder;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Seraph utility class for dealing with cookies.
 * <p>
 * Includes code from Jive 1.2.4 (released under the Apache license)
 * <p>
 * 
 * @deprecated use a {@link CookieHandler}, {@link CookieEncoder} or {@link CookieDecoder} instead.
 */
public class CookieUtils
{
    // the key which represents the list of cookies to add for this request (in case of redirect)
    public static final String COOKIES_TO_SEND = "atlassian.core.web.cookies.unsent";

    /**
     * for backwards compatibility we use the insecure version
     */
    private static final InsecureCookieEncoder cookieEncoder = new InsecureCookieEncoder();

    /**
     * Invalidate the specified cookie and delete it from the response object.
     * 
     * @param response
     *            The HttpServletResponse object, known as "response" in a JSP page.
     * @param cookieName
     *            The name of the cookie you want to delete.
     * @param path
     *            of the path the cookie you want to delete.
     * @deprecated Since 0.10, use {@link com.atlassian.seraph.cookie.CookieHandler} instead
     */
    public static void invalidateCookie(final HttpServletRequest request, final HttpServletResponse response, final String cookieName, final String path)
    {
        CookieFactory.getCookieHandler().invalidateCookie(request, response, cookieName, path);
    }

    /**
     * Invalidate the specified cookie and delete it from the response object. Deletes only cookies mapped against the root "/" path. Otherwise use
     * {@link #invalidateCookie(HttpServletRequest, HttpServletResponse, String, String)}
     * 
     * @param response
     *            The HttpServletResponse object, known as "response" in a JSP page.
     * @param cookieName
     *            The name of the cookie you want to delete.
     * @see #invalidateCookie(HttpServletRequest, HttpServletResponse, String, String)
     * @deprecated Since 0.10, use {@link com.atlassian.seraph.cookie.CookieHandler} instead
     */
    public static void invalidateCookie(final HttpServletRequest request, final HttpServletResponse response, final String cookieName)
    {
        CookieFactory.getCookieHandler().invalidateCookie(request, response, cookieName, "/");
    }

    /**
     * Returns the specified Cookie object, or null if the cookie does not exist.
     * 
     * @param request
     *            The HttpServletRequest object, known as "request" in a JSP page.
     * @param name
     *            the name of the cookie.
     * @return the Cookie object if it exists, otherwise null.
     * @deprecated Since 0.10, use {@link com.atlassian.seraph.cookie.CookieHandler} instead
     */
    public static Cookie getCookie(final HttpServletRequest request, final String name)
    {
        return CookieFactory.getCookieHandler().getCookie(request, name);
    }

    /**
     * Sets a cookie This will also put the cookie in a list of cookies to send with this request's response (so that in case of a redirect occurring
     * down the chain, the first filter will always try to set this cookie again) The cookie secure flag is set if the request is secure.
     * 
     * @deprecated Since 0.10, use {@link com.atlassian.seraph.cookie.CookieHandler} instead
     */
    public static Cookie setCookie(final HttpServletRequest request, final HttpServletResponse response, final String name, final String value, final int maxAge, final String path)
    {
        return CookieFactory.getCookieHandler().setCookie(request, response, name, value, maxAge, path);
    }

    /**
     * Returns the value of the specified cookie as a String. If the cookie does not exist, the method returns null.
     * 
     * @param request
     *            the HttpServletRequest object, known as "request" in a JSP page.
     * @param name
     *            the name of the cookie
     * @return the value of the cookie, or null if the cookie does not exist.
     * @deprecated Since 0.10, use {@link com.atlassian.seraph.cookie.CookieHandler} instead
     */
    public static String getCookieValue(final HttpServletRequest request, final String name)
    {
        return CookieFactory.getCookieHandler().getCookieValue(request, name);
    }

    /**
     * Builds a cookie string containing a username and password.
     * <p>
     * Note: with open source this is not really secure, but it prevents users from snooping the cookie file of others and by changing the XOR mask
     * and character offsets, you can easily tweak results.
     * 
     * @param username
     *            The username.
     * @param password
     *            The password.
     * @return String encoding the input parameters, an empty string if one of the arguments equals <code>null</code>.
     * @deprecated Since 0.10, use {@link com.atlassian.seraph.cookie.CookieEncoder} instead
     */
    public static String encodePasswordCookie(final String username, final String password)
    {
        return encodePasswordCookie(username, password);
    }

    /**
     * Builds a cookie string containing a username and password, using offsets to customise the encoding.
     * <p>
     * Note: with open source this is not really secure, but it prevents users from snooping the cookie file of others and by changing the XOR mask
     * and character offsets, you can easily tweak results.
     * 
     * @param username
     *            The username.
     * @param password
     *            The password.
     * @param encoding
     *            A String used to customise cookie encoding (only the first 3 characters are used)
     * @return String encoding the input parameters, an empty string if one of the arguments equals <code>null</code>.
     * @deprecated Since 0.10, use {@link com.atlassian.seraph.cookie.CookieEncoder} instead
     */
    public static String encodePasswordCookie(final String username, final String password, final String encoding)
    {
        return CookieUtils.cookieEncoder.encodePasswordCookie(username, password, encoding);
    }

    /**
     * Decodes a cookie string containing a username and password.
     * 
     * @param cookieVal
     *            The cookie value.
     * @return String[] containing the username at index 0 and the password at index 1, or <code>{ null, null }</code> if cookieVal equals
     *         <code>null</code> or the empty string.
     * @deprecated Since 0.10, use {@link com.atlassian.seraph.cookie.CookieEncoder} instead
     */
    public static String[] decodePasswordCookie(final String cookieVal)
    {
        return CookieUtils.cookieEncoder.decodePasswordCookie(cookieVal);
    }

    /**
     * Decodes a cookie string containing a username and password.
     * 
     * @param cookieVal
     *            The cookie value.
     * @param encoding
     *            A String used to customise cookie encoding (only the first 3 characters are used) - should be the same string you used to encode the
     *            cookie!
     * @return String[] containing the username at index 0 and the password at index 1, or <code>{ null, null }</code> if cookieVal equals
     *         <code>null</code> or the empty string.
     * @deprecated Since 0.10, use {@link com.atlassian.seraph.cookie.CookieEncoder} instead
     */
    public static String[] decodePasswordCookie(final String cookieVal, final String encoding)
    {
        return CookieUtils.cookieEncoder.decodePasswordCookie(cookieVal, encoding);
    }
}
