package com.atlassian.seraph.util;

import com.atlassian.seraph.config.SecurityConfigFactory;

import com.opensymphony.user.User;

import java.util.Collection;
import java.util.Collections;

import javax.servlet.http.HttpServletRequest;

/**
 * A cache of request (via the remote user) -> group lookups
 *
 * @deprecated This Class relies on com.opensymphony.user.User and is only used in GroupRoleMapper (not used in production).
 */
public class GroupCache
{
    public static final String GROUP_CACHE_KEY = "atlassian.core.util.groups.cache.key";

    /**
     * Get a list of the groups for the current remote user. These groups are cache in a request attribute.
     */
    public static Collection<String> getGroups(final HttpServletRequest request)
    {
        if (request == null)
        {
            return Collections.emptySet();
        }

        {
            @SuppressWarnings("unchecked")
            final Collection<String> groups = (Collection<String>) request.getAttribute(GROUP_CACHE_KEY);
            if (groups != null)
            {
                return groups;
            }
        }

        final User remoteUser = (User) SecurityConfigFactory.getInstance().getAuthenticator().getUser(request);
        if (remoteUser == null)
        {
            return Collections.emptySet();
        }

        @SuppressWarnings("unchecked")
        final Collection<String> groups = remoteUser.getGroups();
        request.setAttribute(GROUP_CACHE_KEY, groups);
        return groups;
    }
}
