/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.auth;

import com.atlassian.seraph.auth.AbstractAuthenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.RoleMapper;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.cookie.CookieFactory;
import com.atlassian.seraph.cookie.CookieHandler;
import com.atlassian.seraph.elevatedsecurity.ElevatedSecurityGuard;
import com.atlassian.seraph.interceptor.LogoutInterceptor;
import com.atlassian.seraph.util.RedirectUtils;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.User;
import com.opensymphony.user.UserManager;
import com.opensymphony.user.provider.ejb.util.Base64;
import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthenticator
extends AbstractAuthenticator {
    public static final String LOGGED_IN_KEY = "seraph_defaultauthenticator_user";
    public static final String LOGGED_OUT_KEY = "seraph_defaultauthenticator_logged_out_user";
    private static final Logger log = Logger.getLogger(DefaultAuthenticator.class);
    private String loginCookieKey;
    private String authType;
    private int autoLoginCookieAge;
    private String loginCookiePath;

    @Override
    public void init(Map<String, String> params, SecurityConfig config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getClass().getName() + " $Revision: 39018 $ initializing"));
        }
        super.init(params, config);
        this.loginCookieKey = config.getLoginCookieKey();
        this.authType = config.getAuthType();
        this.autoLoginCookieAge = config.getAutoLoginCookieAge();
        this.loginCookiePath = config.getLoginCookiePath();
    }

    @Override
    @Deprecated
    public boolean isUserInRole(HttpServletRequest request, String role) {
        return this.getRoleMapper().hasRole(this.getUser(request), request, role);
    }

    @Override
    public boolean login(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean cookie) throws AuthenticatorException {
        String METHOD = "login : ";
        boolean dbg = log.isDebugEnabled();
        Principal user = this.getUser(username);
        CookieHandler cookieHandler = CookieFactory.getCookieHandler();
        if (user == null) {
            log.info((Object)("login : '" + username + "' does not exist and cannot be authenticated."));
        } else {
            boolean authenticated = this.authenticate(user, password);
            if (dbg) {
                log.debug((Object)("login : '" + username + "' has " + (authenticated ? "been" : "not been") + " authenticated"));
            }
            if (authenticated) {
                HttpSession httpSession = request.getSession();
                httpSession.removeAttribute(LOGGED_IN_KEY);
                httpSession.setAttribute(LOGGED_OUT_KEY, null);
                boolean canLogin = this.getRoleMapper().canLogin(user, request);
                if (dbg) {
                    log.debug((Object)("login : '" + username + "' " + (canLogin ? "can" : "CANT") + " login according to the RoleMapper"));
                }
                if (canLogin) {
                    httpSession.setAttribute(LOGGED_IN_KEY, (Object)user);
                    if (cookie && response != null) {
                        cookieHandler.setCookie(request, response, this.getLoginCookieKey(), this.encodeCookie(username, password), this.autoLoginCookieAge, this.getCookiePath(request));
                    }
                    return true;
                }
            } else {
                log.info((Object)("login : '" + username + "' could not be authenticated with the given password"));
            }
        }
        if (response != null && cookieHandler.getCookie(request, this.getLoginCookieKey()) != null) {
            log.warn((Object)("login : '" + username + "' tried to login but they do not have USE permission or weren't found. Deleting cookie."));
            try {
                cookieHandler.invalidateCookie(request, response, this.getLoginCookieKey(), this.getCookiePath(request));
            }
            catch (Exception e) {
                log.error((Object)("login : Could not invalidate cookie: " + e), (Throwable)e);
            }
        }
        return false;
    }

    protected RoleMapper getRoleMapper() {
        return SecurityConfigFactory.getInstance().getRoleMapper();
    }

    protected Principal getUser(String username) {
        String METHOD = "getUser : ";
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUser : Looking in UserManager for '" + username + "'"));
        }
        try {
            return UserManager.getInstance().getUser(username);
        }
        catch (EntityNotFoundException e) {
            log.warn((Object)("getUser : Could not find user '" + username + "' in UserManager : " + (Object)((Object)e)));
            return null;
        }
    }

    protected boolean authenticate(Principal user, String password) {
        return ((User)user).authenticate(password);
    }

    @Override
    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        String METHOD = "logout : ";
        boolean dbg = log.isDebugEnabled();
        if (dbg) {
            log.debug((Object)"logout : Calling interceptors and clearing cookies");
        }
        List<LogoutInterceptor> interceptors = this.getLogoutInterceptors();
        CookieHandler cookieHandler = CookieFactory.getCookieHandler();
        for (LogoutInterceptor interceptor : interceptors) {
            interceptor.beforeLogout(request, response);
        }
        request.getSession().setAttribute(LOGGED_IN_KEY, null);
        request.getSession().setAttribute(LOGGED_OUT_KEY, (Object)Boolean.TRUE);
        if (response != null && cookieHandler.getCookie(request, this.getLoginCookieKey()) != null) {
            try {
                cookieHandler.invalidateCookie(request, response, this.getLoginCookieKey(), this.getCookiePath(request));
            }
            catch (Exception e) {
                log.error((Object)("logout : Could not invalidate cookie: " + e), (Throwable)e);
            }
        }
        Iterator<LogoutInterceptor> i$ = interceptors.iterator();
        while (i$.hasNext()) {
            LogoutInterceptor element;
            LogoutInterceptor interceptor = element = i$.next();
            interceptor.afterLogout(request, response);
        }
        return true;
    }

    @Override
    public Principal getUser(HttpServletRequest request, HttpServletResponse response) {
        Principal basicAuthUser;
        String METHOD = "getUser : ";
        boolean dbg = log.isDebugEnabled();
        if (request.getSession(false) != null) {
            Principal sessionUser = this.getUserFromSession(request);
            if (sessionUser != null) {
                return sessionUser;
            }
        } else {
            Principal cookieUser = this.getUserFromCookie(request, response);
            if (cookieUser != null) {
                return cookieUser;
            }
        }
        if (RedirectUtils.isBasicAuthentication(request, this.authType) && (basicAuthUser = this.getUserFromBasicAuthentication(request, response)) != null) {
            return basicAuthUser;
        }
        if (dbg) {
            log.debug((Object)"getUser : User not found in either Session, Cookie or Basic Auth.");
        }
        return null;
    }

    protected Principal getUserFromCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ElevatedSecurityGuard securityGuard;
        String[] values;
        String METHOD = "getUserFromCookie : ";
        boolean dbg = log.isDebugEnabled();
        String cookieName = this.getLoginCookieKey();
        Cookie cookie = CookieFactory.getCookieHandler().getCookie(httpServletRequest, cookieName);
        if (cookie == null) {
            if (dbg) {
                log.debug((Object)("getUserFromCookie : No cookie called '" + cookieName + "' found.  No principal returned."));
            }
            return null;
        }
        String cookieValue = cookie.getValue();
        if (dbg) {
            log.debug((Object)("getUserFromCookie : Found cookie : '" + cookieName + "' with value : '" + cookieValue + "'"));
        }
        if ((values = this.decodeCookie(cookieValue)) == null) {
            if (dbg) {
                log.debug((Object)("getUserFromCookie : Unable to decode " + cookieName + " cookie with value : '" + cookieValue + "'"));
            }
            return null;
        }
        String userName = values[0];
        String password = values[1];
        if (dbg) {
            log.debug((Object)("getUserFromCookie : Got username : '" + userName + "' and password from cookie, attempting to authenticate user"));
        }
        if (!(securityGuard = this.getElevatedSecurityGuard()).performElevatedSecurityCheck(httpServletRequest, userName)) {
            if (dbg) {
                log.debug((Object)("getUserFromCookie : '" + userName + "' failed elevated security check"));
            }
            securityGuard.onFailedLoginAttempt(httpServletRequest, userName);
            return null;
        }
        try {
            boolean loggedin = this.login(httpServletRequest, httpServletResponse, userName, password, false);
            if (!loggedin) {
                securityGuard.onFailedLoginAttempt(httpServletRequest, userName);
                return null;
            }
            securityGuard.onSuccessfulLoginAttempt(httpServletRequest, userName);
        }
        catch (Exception e) {
            log.warn((Object)("getUserFromCookie : Cookie login for user : '" + userName + "' failed with exception: " + e), (Throwable)e);
            return null;
        }
        if (dbg) {
            log.debug((Object)("getUserFromCookie : Authenticated '" + userName + "' via a cookie.  Now getting them again from the session"));
        }
        return this.getUserFromSession(httpServletRequest);
    }

    protected Principal getUserFromSession(HttpServletRequest request) {
        String METHOD = "getUserFromSession : ";
        boolean dbg = log.isDebugEnabled();
        try {
            if (request.getSession().getAttribute(LOGGED_OUT_KEY) != null) {
                if (dbg) {
                    log.debug((Object)"getUserFromSession : Session found; user has already logged out. eg has LOGGED_OUT_KEY in session");
                }
                return null;
            }
            Principal principal = (Principal)request.getSession().getAttribute(LOGGED_IN_KEY);
            if (dbg) {
                if (principal == null) {
                    log.debug((Object)"getUserFromSession : Session found; BUT it has no Principal in it");
                } else {
                    log.debug((Object)("getUserFromSession : Session found; '" + principal.getName() + "' is present"));
                }
            }
            return principal;
        }
        catch (Exception e) {
            log.warn((Object)("getUserFromSession : Exception when retrieving user from session: " + e), (Throwable)e);
            return null;
        }
    }

    protected Principal getUserFromBasicAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String METHOD = "getUserFromSession : ";
        boolean dbg = log.isDebugEnabled();
        String header = httpServletRequest.getHeader("Authorization");
        if (header != null && header.startsWith("Basic ")) {
            ElevatedSecurityGuard securityGuard;
            if (dbg) {
                log.debug((Object)"getUserFromSession : Looking in Basic Auth headers");
            }
            String base64Token = header.substring(6);
            String token = new String(Base64.decode((byte[])base64Token.getBytes()));
            String userName = "";
            String password = "";
            int delim = token.indexOf(":");
            if (delim != -1) {
                userName = token.substring(0, delim);
                password = token.substring(delim + 1);
            }
            if (!(securityGuard = this.getElevatedSecurityGuard()).performElevatedSecurityCheck(httpServletRequest, userName)) {
                if (dbg) {
                    log.debug((Object)("getUserFromSession : '" + userName + "' failed elevated security check"));
                }
                securityGuard.onFailedLoginAttempt(httpServletRequest, userName);
            } else {
                if (dbg) {
                    log.debug((Object)("getUserFromSession : '" + userName + "' does not require elevated security check.  Attempting authentication..."));
                }
                try {
                    boolean loggedin = this.login(httpServletRequest, httpServletResponse, userName, password, false);
                    if (loggedin) {
                        securityGuard.onSuccessfulLoginAttempt(httpServletRequest, userName);
                        if (dbg) {
                            log.debug((Object)("getUserFromSession : Authenticated '" + userName + "' via Basic Auth"));
                        }
                        return this.getUser(userName);
                    }
                    securityGuard.onFailedLoginAttempt(httpServletRequest, userName);
                }
                catch (AuthenticatorException e) {
                    log.warn((Object)("getUserFromSession : Exception trying to login '" + userName + "' via Basic Auth:" + e), (Throwable)e);
                }
            }
            try {
                httpServletResponse.sendError(401);
            }
            catch (IOException e) {
                log.warn((Object)("getUserFromSession : Exception trying to send Basic Auth failed error: " + e), (Throwable)e);
            }
            return null;
        }
        httpServletResponse.setStatus(401);
        httpServletResponse.setHeader("WWW-Authenticate", "BASIC realm=\"protected-area\"");
        return null;
    }

    protected String getCookiePath(HttpServletRequest request) {
        if (this.getLoginCookiePath() != null) {
            return this.getLoginCookiePath();
        }
        String path = request.getContextPath();
        if (path == null || path.equals("")) {
            return "/";
        }
        if (!path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }

    protected String getLoginCookieKey() {
        return this.loginCookieKey;
    }

    public String getAuthType() {
        return this.authType;
    }

    protected List<LogoutInterceptor> getLogoutInterceptors() {
        return this.getConfig().getInterceptors(LogoutInterceptor.class);
    }

    protected String encodeCookie(String username, String password) {
        return CookieFactory.getCookieEncoder().encodePasswordCookie(username, password, this.getConfig().getCookieEncoding());
    }

    protected String[] decodeCookie(String value) {
        return CookieFactory.getCookieEncoder().decodePasswordCookie(value, this.getConfig().getCookieEncoding());
    }

    protected String getLoginCookiePath() {
        return this.loginCookiePath;
    }

    protected ElevatedSecurityGuard getElevatedSecurityGuard() {
        return this.getConfig().getElevatedSecurityGuard();
    }
}

