/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.filter;

import com.atlassian.seraph.SecurityService;
import com.atlassian.seraph.auth.AuthenticationContext;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.util.RedirectUtils;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public class SecurityFilter
implements Filter {
    private FilterConfig config = null;
    private SecurityConfig securityConfig = null;
    private static final Category log = Category.getInstance(SecurityFilter.class);
    private static final String ALREADY_FILTERED = "os_securityfilter_already_filtered";
    public static final String ORIGINAL_URL = "atlassian.core.seraph.original.url";

    public void init(FilterConfig config) {
        log.debug((Object)"SecurityFilter.init");
        this.config = config;
        String configFileLocation = null;
        if (config.getInitParameter("config.file") != null) {
            configFileLocation = config.getInitParameter("config.file");
            log.debug((Object)("Security config file location: " + configFileLocation));
        }
        this.securityConfig = SecurityConfigFactory.getInstance(configFileLocation);
        config.getServletContext().setAttribute("seraph_config", (Object)this.securityConfig);
        log.debug((Object)"SecurityFilter.init completed successfully.");
    }

    public void destroy() {
        log.debug((Object)"SecurityFilter.destroy");
        if (this.securityConfig == null) {
            log.warn((Object)"Trying to destroy a SecurityFilter with null securityConfig.");
        } else {
            this.securityConfig.destroy();
            this.securityConfig = null;
        }
        this.config = null;
    }

    @Deprecated
    public FilterConfig getFilterConfig() {
        return this.config;
    }

    @Deprecated
    public void setFilterConfig(FilterConfig filterConfig) {
        if (filterConfig != null) {
            this.init(filterConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(ALREADY_FILTERED) != null || !this.getSecurityConfig().getController().isSecurityEnabled()) {
            chain.doFilter(req, res);
            return;
        }
        req.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
        if (req.getAttribute("loginfilter.already.filtered") == null) {
            log.warn((Object)"LoginFilter not yet applied to this request - terminating filter chain");
            return;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String originalURL = request.getServletPath() + (request.getPathInfo() == null ? "" : request.getPathInfo()) + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
        request.setAttribute(ORIGINAL_URL, (Object)originalURL);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storing the originally requested URL (atlassian.core.seraph.original.url=" + originalURL + ")"));
        }
        HashSet<String> requiredRoles = new HashSet<String>();
        for (SecurityService service : this.getSecurityConfig().getServices()) {
            Set<String> serviceRoles = service.getRequiredRoles(request);
            requiredRoles.addAll(serviceRoles);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("requiredRoles = " + requiredRoles));
        }
        boolean needAuth = false;
        Principal user = this.getSecurityConfig().getAuthenticator().getUser(request, response);
        boolean basicAuthentication = RedirectUtils.isBasicAuthentication(request, this.getSecurityConfig().getAuthType());
        if (basicAuthentication && user == null) {
            log.debug((Object)"Basic authentication requested.");
            return;
        }
        this.getAuthenticationContext().setUser(user);
        Iterator i$ = requiredRoles.iterator();
        while (i$.hasNext()) {
            String element;
            String role = element = (String)i$.next();
            if (this.getSecurityConfig().getRoleMapper().hasRole(user, request, role)) continue;
            log.info((Object)("User '" + user + "' needs (and lacks) role '" + role + "' to access " + originalURL));
            needAuth = true;
        }
        if (request.getServletPath() != null && request.getServletPath().equals(this.getSecurityConfig().getLoginURL())) {
            log.debug((Object)"Login page requested so no additional authorization required.");
            needAuth = false;
        }
        if (needAuth) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Need Authentication: Redirecting to: " + this.getSecurityConfig().getLoginURL() + " from: " + originalURL));
            }
            request.getSession().setAttribute(this.getSecurityConfig().getOriginalURLKey(), (Object)originalURL);
            if (!response.isCommitted()) {
                response.sendRedirect(RedirectUtils.getLoginUrl(request));
            }
            return;
        }
        try {
            chain.doFilter(req, res);
        }
        finally {
            this.getAuthenticationContext().clearUser();
        }
    }

    protected SecurityConfig getSecurityConfig() {
        if (this.securityConfig == null) {
            this.securityConfig = (SecurityConfig)this.config.getServletContext().getAttribute("seraph_config");
        }
        return this.securityConfig;
    }

    protected AuthenticationContext getAuthenticationContext() {
        return this.getSecurityConfig().getAuthenticationContext();
    }
}

