package com.atlassian.seraph.config;

import com.atlassian.seraph.SecurityService;
import com.atlassian.seraph.auth.AuthenticationContext;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.RoleMapper;
import com.atlassian.seraph.controller.SecurityController;
import com.atlassian.seraph.interceptor.Interceptor;

import java.util.List;

public interface SecurityConfig
{
    String STORAGE_KEY = "seraph_config";
    String BASIC_AUTH = "basic";

    List<SecurityService> getServices();

    String getLoginURL();

    String getLinkLoginURL();

    String getLogoutURL();

    String getOriginalURLKey();

    Authenticator getAuthenticator();

    AuthenticationContext getAuthenticationContext();

    SecurityController getController();

    RoleMapper getRoleMapper();

    /**
     * Returns the configured RedirectPolicy, or the default if none is configured.
     * Will never return null.
     * @return The configured RedirectPolicy, or the default if none is configured.
     */
    RedirectPolicy getRedirectPolicy();

    <T extends Interceptor> List<T> getInterceptors(Class<T> desiredInterceptorClass);

    String getCookieEncoding();

    /**
     * @return The path to use for the autologin cookie
     */
    String getLoginCookiePath();

    String getLoginCookieKey();

    void destroy();

    String getAuthType();

    boolean isInsecureCookie();

    /**
     * Autologin cookie age in seconds.
     * @return Autologin cookie age in seconds.
     */
    int getAutoLoginCookieAge();
}
