/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.log4j.Logger;

public class EncryptionUtils {
    private static final Logger log = Logger.getLogger(EncryptionUtils.class);
    private static final byte[] SALT = new byte[]{-62, 116, 36, 76, 124, -40, -18, -103};
    private static final int ITERATIONS = 21;
    private PBEParameterSpec pbeParamSpec = new PBEParameterSpec(SALT, 21);
    private SecretKey pbeKey;

    public String encrypt(String data) {
        try {
            Cipher pbeCipher = this.createCipher(true);
            return EncryptionUtils.encode(pbeCipher.doFinal(data.getBytes()));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Cipher createCipher(boolean encrypt) throws GeneralSecurityException {
        if (this.pbeKey == null) {
            throw new IllegalStateException("The password has not be set");
        }
        Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
        pbeCipher.init(encrypt ? 1 : 2, (Key)this.pbeKey, this.pbeParamSpec);
        return pbeCipher;
    }

    public String decrypt(String encData) {
        try {
            Cipher pbeCipher = this.createCipher(false);
            return new String(pbeCipher.doFinal(EncryptionUtils.decode(encData)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] decode(String encoded) {
        int offsetsIndex = encoded.length() / 2;
        char[] encodedPageNumbers = encoded.substring(0, offsetsIndex).toCharArray();
        char[] encodedOffsets = encoded.substring(offsetsIndex).toCharArray();
        byte[] bytes = new byte[offsetsIndex];
        for (int i = 0; i < bytes.length; ++i) {
            int pageNumber = EncryptionUtils.decodePageNumber(encodedPageNumbers[i]);
            byte offset = EncryptionUtils.decodeOffset(encodedOffsets[i]);
            if (pageNumber < 0 || pageNumber > 3) {
                log.debug((Object)("Invalid encoded page number '" + encodedPageNumbers[i] + "', decoded as " + pageNumber + ". Skipping byte."));
                continue;
            }
            bytes[i] = (byte)(pageNumber * 64 - 128 + offset);
        }
        return bytes;
    }

    static byte decodeOffset(char encodedOffset) {
        if ('0' <= encodedOffset && encodedOffset <= '9') {
            return (byte)(encodedOffset - 48);
        }
        if ('A' <= encodedOffset && encodedOffset <= 'Z') {
            return (byte)(encodedOffset - 65 + 10);
        }
        if ('a' <= encodedOffset && encodedOffset <= 'z') {
            return (byte)(encodedOffset - 97 + 36);
        }
        if (encodedOffset == '<') {
            return 62;
        }
        if (encodedOffset == '>') {
            return 63;
        }
        log.debug((Object)("Cannot decode invalid encoded offset '" + encodedOffset + "'. Must be one of [A-Za-z0-9<>]. Returning default value '2'."));
        return 2;
    }

    static String encode(byte[] plainBytes) {
        StringBuffer encodedPageNumbers = new StringBuffer(plainBytes.length);
        StringBuffer encodedOffsets = new StringBuffer(plainBytes.length);
        for (int i = 0; i < plainBytes.length; ++i) {
            byte aByte = plainBytes[i];
            int pageNumber = (aByte + 128) / 64;
            encodedPageNumbers.append(EncryptionUtils.encodePageNumber(pageNumber));
            int offset = (aByte + 128) % 64;
            encodedOffsets.append(EncryptionUtils.encodeOffset(offset));
        }
        return encodedPageNumbers.toString() + encodedOffsets.toString();
    }

    static char encodePageNumber(int pageNumber) {
        int randomChar = pageNumber * 6 + (int)(Math.random() * 6.0);
        boolean upperCase = (int)(Math.random() * 2.0) < 1;
        return (char)(randomChar + (upperCase ? 65 : 97));
    }

    static int decodePageNumber(char encodedPageNumber) {
        return (Character.toLowerCase(encodedPageNumber) - 97) / 6;
    }

    static char encodeOffset(int offset) {
        if (offset < 0 || offset > 63) {
            log.debug((Object)("Invalid offset to encode: " + offset + ". Should be between 0 and 63. Returning null character."));
            return '\u0000';
        }
        if (offset < 10) {
            return (char)(offset + 48);
        }
        if (offset < 36) {
            return (char)(offset - 10 + 65);
        }
        if (offset < 62) {
            return (char)(offset - 36 + 97);
        }
        if (offset < 63) {
            return '<';
        }
        return '>';
    }

    public void setPassword(String password) {
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
        try {
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            this.pbeKey = keyFac.generateSecret(pbeKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Encryption algorithm not found", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Invalid passphrase", e);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: com.atlassian.payment.encrypted.EncryptionUtils [encrypt|decrypt]");
            System.exit(1);
        }
        EncryptionUtils utils = new EncryptionUtils();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        if ("encrypt".equals(args[0])) {
            System.out.println("Enter the text to encrypt:");
            String text = in.readLine();
            System.out.println("\n" + utils.encrypt(text) + "\n");
        } else {
            System.out.println("Paste the encrypted text:");
            String cdata = in.readLine();
            System.out.println(utils.decrypt(cdata));
        }
    }
}

