package com.atlassian.seraph.util;

import com.atlassian.seraph.config.SecurityConfigFactory;

import com.opensymphony.user.User;

import java.util.Collection;
import java.util.Collections;

import javax.servlet.http.HttpServletRequest;

/**
 * A cache of request (via the remote user) -> group lookups
 */
public class GroupCache
{
    public static final String GROUP_CACHE_KEY = "atlassian.core.util.groups.cache.key";

    /**
     * Get a list of the groups for the current remote user. These groups are cache in a request attribute.
     */
    public static Collection getGroups(final HttpServletRequest request)
    {
        if (request == null)
        {
            return Collections.EMPTY_LIST;
        }

        Collection groups = (Collection) request.getAttribute(GROUP_CACHE_KEY);

        if (groups != null)
        {
            return groups;
        }

        final User remoteUser = (User) SecurityConfigFactory.getInstance().getAuthenticator().getUser(request);

        if (remoteUser == null)
        {
            return Collections.EMPTY_LIST;
        }

        groups = remoteUser.getGroups();
        request.setAttribute(GROUP_CACHE_KEY, groups);
        return groups;
    }
}
